// This file was automatically generated by informer-gen

package internalversion

import (
	user "github.com/openshift/origin/pkg/user/apis/user"
	internalinterfaces "github.com/openshift/origin/pkg/user/generated/informers/internalversion/internalinterfaces"
	internalclientset "github.com/openshift/origin/pkg/user/generated/internalclientset"
	internalversion "github.com/openshift/origin/pkg/user/generated/listers/user/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// IdentityInformer provides access to a shared informer and lister for
// Identities.
type IdentityInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.IdentityLister
}

type identityInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newIdentityInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				return client.User().Identities().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				return client.User().Identities().Watch(options)
			},
		},
		&user.Identity{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *identityInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&user.Identity{}, newIdentityInformer)
}

func (f *identityInformer) Lister() internalversion.IdentityLister {
	return internalversion.NewIdentityLister(f.Informer().GetIndexer())
}
