// This file was automatically generated by lister-gen

package v1

import (
	v1 "github.com/openshift/origin/pkg/user/apis/user/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IdentityLister helps list Identities.
type IdentityLister interface {
	// List lists all Identities in the indexer.
	List(selector labels.Selector) (ret []*v1.Identity, err error)
	// Get retrieves the Identity from the index for a given name.
	Get(name string) (*v1.Identity, error)
	IdentityListerExpansion
}

// identityLister implements the IdentityLister interface.
type identityLister struct {
	indexer cache.Indexer
}

// NewIdentityLister returns a new IdentityLister.
func NewIdentityLister(indexer cache.Indexer) IdentityLister {
	return &identityLister{indexer: indexer}
}

// List lists all Identities in the indexer.
func (s *identityLister) List(selector labels.Selector) (ret []*v1.Identity, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Identity))
	})
	return ret, err
}

// Get retrieves the Identity from the index for a given name.
func (s *identityLister) Get(name string) (*v1.Identity, error) {
	key := &v1.Identity{ObjectMeta: meta_v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("identity"), name)
	}
	return obj.(*v1.Identity), nil
}
