// conversion-gen is a tool for auto-generating Conversion functions.
//
// Structs in the input directories with the below line in their comments
// will be ignored during generation.
// // +genconversion=false
package main

import (
	"strings"

	"github.com/golang/glog"

	"k8s.io/apimachinery/pkg/util/sets"
	"k8s.io/gengo/args"
	"k8s.io/gengo/generator"

	"k8s.io/kube-gen/cmd/conversion-gen/generators"
)

func main() {
	arguments := args.Default()

	// These are the packages we expect generated conversions for
	expectedPackages := sets.NewString(
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1",
		"github.com/openshift/origin/pkg/build/apis/build/v1",
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1",
		"github.com/openshift/origin/pkg/image/apis/image/v1",
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1",
		"github.com/openshift/origin/pkg/project/apis/project/v1",
		"github.com/openshift/origin/pkg/quota/apis/quota/v1",
		"github.com/openshift/origin/pkg/route/apis/route/v1",
		"github.com/openshift/origin/pkg/sdn/apis/network/v1",
		"github.com/openshift/origin/pkg/template/apis/template/v1",
		"github.com/openshift/origin/pkg/user/apis/user/v1",
		"github.com/openshift/origin/pkg/security/apis/security/v1",
		"github.com/openshift/origin/pkg/template/servicebroker/apis/config/v1",
	)

	// These are the packages containing types and conversion functions used by the packages we want to generate for
	supportingPackages := sets.NewString(
		"k8s.io/kubernetes/pkg/api/v1",
		"k8s.io/kubernetes/pkg/api",
		"k8s.io/apimachinery/pkg/apis/meta/v1",
		"k8s.io/apimachinery/pkg/apis/meta/internalversion",
		"k8s.io/apimachinery/pkg/runtime",
		"k8s.io/apimachinery/pkg/conversion",
		"github.com/openshift/origin/pkg/authorization/apis/authorization",
		"github.com/openshift/origin/pkg/build/apis/build",
		"github.com/openshift/origin/pkg/deploy/apis/apps",
		"github.com/openshift/origin/pkg/image/apis/image",
		"github.com/openshift/origin/pkg/oauth/apis/oauth",
		"github.com/openshift/origin/pkg/project/apis/project",
		"github.com/openshift/origin/pkg/quota/apis/quota",
		"github.com/openshift/origin/pkg/route/apis/route",
		"github.com/openshift/origin/pkg/sdn/apis/network",
		"github.com/openshift/origin/pkg/template/apis/template",
		"github.com/openshift/origin/pkg/user/apis/user",
		"github.com/openshift/origin/pkg/security/apis/security",
	)

	// Override defaults. These are Kubernetes specific input locations.
	arguments.InputDirs = sets.NewString().Union(expectedPackages).Union(supportingPackages).List()

	arguments.GeneratedBuildTag = "ignore_autogenerated_openshift"
	arguments.GoHeaderFilePath = "hack/boilerplate.txt"
	arguments.OutputFileBaseName = "zz_generated.conversion"

	foundPackages := sets.NewString()

	if err := arguments.Execute(
		generators.NameSystems(),
		generators.DefaultNameSystem(),
		func(context *generator.Context, arguments *args.GeneratorArgs) generator.Packages {
			pkgs := generators.Packages(context, arguments)
			var include generator.Packages
			for _, pkg := range pkgs {
				foundPackages.Insert(pkg.Path())
				if strings.HasPrefix(pkg.Path(), "k8s.io/") {
					continue
				}
				include = append(include, pkg)
			}
			return include
		},
	); err != nil {
		glog.Fatalf("Error: %v", err)
	}

	if missing := expectedPackages.Difference(foundPackages); len(missing) > 0 {
		glog.Fatalf("Missing expected packages:\n%v", missing.List())
	}

	glog.Info("Completed successfully.")
}
