/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.hl7;

/**
 * HL7 Constants
 */
public final class HL7Constants {

    public static final String HL7_SENDING_APPLICATION = "CamelHL7SendingApplication";
    public static final String HL7_SENDING_FACILITY = "CamelHL7SendingFacility";
    public static final String HL7_RECEIVING_APPLICATION = "CamelHL7ReceivingApplication";
    public static final String HL7_RECEIVING_FACILITY = "CamelHL7ReceivingFacility";
    public static final String HL7_TIMESTAMP = "CamelHL7Timestamp";
    public static final String HL7_SECURITY = "CamelHL7Security";
    public static final String HL7_MESSAGE_TYPE = "CamelHL7MessageType";
    public static final String HL7_TRIGGER_EVENT = "CamelHL7TriggerEvent";
    public static final String HL7_MESSAGE_CONTROL = "CamelHL7MessageControl";
    public static final String HL7_PROCESSING_ID = "CamelHL7ProcessingId";
    public static final String HL7_VERSION_ID = "CamelHL7VersionId";
    public static final String HL7_CONTEXT = "CamelHL7Context";
    public static final String HL7_CHARSET = "CamelHL7Charset";

    private HL7Constants() {
    }
}
