/*
 * #%L
 * Wildfly Camel :: Testsuite
 * %%
 * Copyright (C) 2013 - 2014 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package org.wildfly.camel.test.jackson;

import org.apache.camel.component.jackson.JacksonDataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(Arquillian.class)
public class JacksonIntegrationTest {

    @Deployment
    public static JavaArchive deployment() {
        final JavaArchive archive = ShrinkWrap.create(JavaArchive.class, "jackson-tests");
        return archive;
    }

    @Test
    public void testClassLoader() throws Exception {

        ClassLoader componentLoader = JacksonDataFormat.class.getClassLoader();
        Assert.assertTrue("Not a ModuleClassLoader: " + componentLoader, componentLoader instanceof ModuleClassLoader);
        Assert.assertEquals("org.apache.camel.component.jackson", ((ModuleClassLoader) componentLoader).getModule().getName());

        ClassLoader moduleLoader = componentLoader.loadClass("com.fasterxml.jackson.annotation.JsonIgnoreProperties").getClassLoader();
        Assert.assertTrue("Not a ModuleClassLoader: " + moduleLoader, moduleLoader instanceof ModuleClassLoader);
        Assert.assertEquals("com.fasterxml.jackson.core.jackson-annotations", ((ModuleClassLoader) moduleLoader).getModule().getName());

        moduleLoader = componentLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper").getClassLoader();
        Assert.assertTrue("Not a ModuleClassLoader: " + moduleLoader, moduleLoader instanceof ModuleClassLoader);
        Assert.assertEquals("com.fasterxml.jackson.core.jackson-databind", ((ModuleClassLoader) moduleLoader).getModule().getName());

        ClassLoader deploymentLoader = getClass().getClassLoader();

        moduleLoader = deploymentLoader.loadClass("com.fasterxml.jackson.annotation.JsonIgnoreProperties").getClassLoader();
        Assert.assertTrue("Not a ModuleClassLoader: " + moduleLoader, moduleLoader instanceof ModuleClassLoader);
        Assert.assertEquals("com.fasterxml.jackson.core.jackson-annotations", ((ModuleClassLoader) moduleLoader).getModule().getName());

        moduleLoader = deploymentLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper").getClassLoader();
        Assert.assertTrue("Not a ModuleClassLoader: " + moduleLoader, moduleLoader instanceof ModuleClassLoader);
        Assert.assertEquals("com.fasterxml.jackson.core.jackson-databind", ((ModuleClassLoader) moduleLoader).getModule().getName());
    }
}
