/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.connector.meta;

import java.io.IOException;

import io.syndesis.connector.support.verifier.api.PropertyPair;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using = PropertyPairDeserializer.class)
public final class PropertyPairDeserializer extends JsonDeserializer<PropertyPair> {

    @Override
    public PropertyPair deserialize(final JsonParser p, final DeserializationContext ctxt) throws IOException, JsonProcessingException {
        final TreeNode nodes = p.readValueAsTree();

        return new PropertyPair(((JsonNode) nodes.path("value")).asText(), ((JsonNode) nodes.get("displayValue")).asText());
    }

}
