/*
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.atlasmap.itests.validation;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.core.DefaultAtlasContextFactory;

public abstract class AtlasMappingBaseTest {

    protected AtlasContextFactory atlasContextFactory = null;
    protected String testMethodName;

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        testMethodName = testInfo.getTestMethod().get().getName();
        atlasContextFactory = DefaultAtlasContextFactory.getInstance();
    }

    @AfterEach
    public void tearDown() {
        atlasContextFactory = null;
    }

}
