# Generating the One-Off patch for CVE-2021-22573

The patch for CVE-2021-22573 containes changes to this set of paths

```
modules/system/layers/fuse/com/google/oauth-client/google-oauth-client/
```

## Building the One-Off patch

```
mvn clean install -pl patch -am -PCVE-2021-22573
...
[INFO] --- maven-assembly-plugin:3.3.0:single (one-off-patch) @ wildfly-camel-patch ---
[INFO] Reading assembly descriptor: scripts/assembly-wildfly-patch-CVE-2021-22573.xml
[INFO] Building zip: .../wildfly-camel/patch/target/wildfly-camel-patch-5.8.0.fuse-CVE-2021-22573.zip
```

## Adding the One-Off patch to the Repository

The [fuse-patch](https://github.com/jboss-fuse/fuse-patch) tool has a notion of [Repository](https://github.com/jboss-fuse/fuse-patch/blob/3.4.x.redhat-7-x/docs/UserGuide.md#loading-the-repository) that contains the set of archives that can be applied to a given EAP instance. 

Lets first verify that the EAP instance already has a wildfly-camel distro installed ... 

```
bin/fusepatch.sh --query-repository

bin/fusepatch.sh --query-server
wildfly-camel-distro-5.8.0.fuse-7_10_2-00001-redhat-00005
```

Ok, now that we know the Fuse EAP distro version that we want to patch, we can add the patch file to the repository.
Note, it is important the that patch file name starts with whatever we give in the `--one-off` parameter.

```
bin/fusepatch.sh \
  --one-off wildfly-camel-distro-5.8.0.fuse-7_10_2-00001-redhat-00005 \
  --add file:.../wildfly-camel-distro-5.8.0.fuse-7_10_2-00001-redhat-00005-CVE-2021-22573.zip
```

Finally, we can apply the patch like this ...

```
bin/fusepatch.sh --update fuse-eap-distro
```


## Installing Fuse-Patch on a clean EAP instance

```
FUSE_PATCH_VERSION=3.4.0.fuse-7_10_2-00001
tar xzf $HOME/.m2/repository/org/wildfly/extras/patch/fuse-patch-distro-wildfly/${FUSE_PATCH_VERSION}/fuse-patch-distro-wildfly-${FUSE_PATCH_VERSION}.zip 
```

## Installing WildFly-Camel with Fuse-Patch

```
SOURCE_DIR=$HOME/.m2/repository/org/wildfly/camel/fuse-eap-distro/${WILDFLY_CAMEL_TARGET_VERSION}
bin/fusepatch.sh --add file:${SOURCE_DIR}/fuse-eap-distro-${WILDFLY_CAMEL_TARGET_VERSION}.zip

bin/fusepatch.sh --force --install fuse-eap-distro-${WILDFLY_CAMEL_TARGET_VERSION}
```
