/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String fullString, String segment, JsonPointer next2) {
        this._asString = fullString;
        this._nextSegment = next2;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = JsonPointer._parseIndex(segment);
    }

    protected JsonPointer(String fullString, String segment, int matchIndex, JsonPointer next2) {
        this._asString = fullString;
        this._nextSegment = next2;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = matchIndex;
    }

    public static JsonPointer compile(String input2) throws IllegalArgumentException {
        if (input2 == null || input2.length() == 0) {
            return EMPTY;
        }
        if (input2.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + input2 + "\"");
        }
        return JsonPointer._parseTail(input2);
    }

    public static JsonPointer valueOf(String input2) {
        return JsonPointer.compile(input2);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer next2;
        JsonPointer current = this;
        if (current == EMPTY) {
            return null;
        }
        while ((next2 = current._nextSegment) != EMPTY) {
            current = next2;
        }
        return current;
    }

    public JsonPointer append(JsonPointer tail2) {
        if (this == EMPTY) {
            return tail2;
        }
        if (tail2 == EMPTY) {
            return this;
        }
        String currentJsonPointer = this._asString;
        if (currentJsonPointer.endsWith("/")) {
            currentJsonPointer = currentJsonPointer.substring(0, currentJsonPointer.length() - 1);
        }
        return JsonPointer.compile(currentJsonPointer + tail2._asString);
    }

    public boolean matchesProperty(String name2) {
        return this._nextSegment != null && this._matchingPropertyName.equals(name2);
    }

    public JsonPointer matchProperty(String name2) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(name2)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int index2) {
        return index2 == this._matchingElementIndex && index2 >= 0;
    }

    public JsonPointer matchElement(int index2) {
        if (index2 != this._matchingElementIndex || index2 < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer h2 = this._head;
        if (h2 == null) {
            if (this != EMPTY) {
                h2 = this._constructHead();
            }
            this._head = h2;
        }
        return h2;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)o)._asString);
    }

    private static final int _parseIndex(String str) {
        long l;
        int len = str.length();
        if (len == 0 || len > 10) {
            return -1;
        }
        char c = str.charAt(0);
        if (c <= '0') {
            return len == 1 && c == '0' ? 0 : -1;
        }
        if (c > '9') {
            return -1;
        }
        for (int i = 1; i < len; ++i) {
            c = str.charAt(i);
            if (c <= '9' && c >= '0') continue;
            return -1;
        }
        if (len == 10 && (l = NumberInput.parseLong(str)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(str);
    }

    protected static JsonPointer _parseTail(String input2) {
        int end2 = input2.length();
        int i = 1;
        while (i < end2) {
            char c = input2.charAt(i);
            if (c == '/') {
                return new JsonPointer(input2, input2.substring(1, i), JsonPointer._parseTail(input2.substring(i)));
            }
            if (c != '~' || ++i >= end2) continue;
            return JsonPointer._parseQuotedTail(input2, i);
        }
        return new JsonPointer(input2, input2.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String input2, int i) {
        int end2 = input2.length();
        StringBuilder sb = new StringBuilder(Math.max(16, end2));
        if (i > 2) {
            sb.append(input2, 1, i - 1);
        }
        JsonPointer._appendEscape(sb, input2.charAt(i++));
        while (i < end2) {
            char c = input2.charAt(i);
            if (c == '/') {
                return new JsonPointer(input2, sb.toString(), JsonPointer._parseTail(input2.substring(i)));
            }
            if (c == '~' && ++i < end2) {
                JsonPointer._appendEscape(sb, input2.charAt(i++));
                continue;
            }
            sb.append(c);
        }
        return new JsonPointer(input2, sb.toString(), EMPTY);
    }

    protected JsonPointer _constructHead() {
        JsonPointer last2 = this.last();
        if (last2 == this) {
            return EMPTY;
        }
        int suffixLength = last2._asString.length();
        JsonPointer next2 = this._nextSegment;
        return new JsonPointer(this._asString.substring(0, this._asString.length() - suffixLength), this._matchingPropertyName, this._matchingElementIndex, next2._constructHead(suffixLength, last2));
    }

    protected JsonPointer _constructHead(int suffixLength, JsonPointer last2) {
        if (this == last2) {
            return EMPTY;
        }
        JsonPointer next2 = this._nextSegment;
        String str = this._asString;
        return new JsonPointer(str.substring(0, str.length() - suffixLength), this._matchingPropertyName, this._matchingElementIndex, next2._constructHead(suffixLength, last2));
    }

    private static void _appendEscape(StringBuilder sb, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            sb.append('~');
        }
        sb.append(c);
    }
}

