/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();

    private DurationDeserializer() {
        super(Duration.class);
    }

    @Override
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                BigDecimal value2 = parser.getDecimalValue();
                long seconds = value2.longValue();
                int nanoseconds = DecimalUtils.extractNanosecondDecimal(value2, seconds);
                return Duration.ofSeconds(seconds, nanoseconds);
            }
            case 7: {
                if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return Duration.ofSeconds(parser.getLongValue());
                }
                return Duration.ofMillis(parser.getLongValue());
            }
            case 6: {
                String string2 = parser.getText().trim();
                if (string2.length() == 0) {
                    return null;
                }
                return Duration.parse(string2);
            }
        }
        throw context.mappingException("Expected type float, integer, or string.");
    }
}

