/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RFC2109Spec
extends CookieSpecBase {
    private static final CookiePathComparator PATH_COMPARATOR = new CookiePathComparator();
    private static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2109Spec(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS;
        this.oneHeader = oneHeader;
        this.registerAttribHandler("version", new RFC2109VersionHandler());
        this.registerAttribHandler("path", new BasicPathHandler());
        this.registerAttribHandler("domain", new RFC2109DomainHandler());
        this.registerAttribHandler("max-age", new BasicMaxAgeHandler());
        this.registerAttribHandler("secure", new BasicSecureHandler());
        this.registerAttribHandler("comment", new BasicCommentHandler());
        this.registerAttribHandler("expires", new BasicExpiresHandler(this.datepatterns));
    }

    public RFC2109Spec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin2) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin2 == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] elems = header.getElements();
        return this.parse(elems, origin2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        String name2 = cookie.getName();
        if (name2.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("Cookie name may not contain blanks");
        }
        if (name2.startsWith("$")) {
            throw new CookieRestrictionViolationException("Cookie name may not start with $");
        }
        super.validate(cookie, origin2);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("List of cookies may not be null");
        }
        if (cookies.isEmpty()) {
            throw new IllegalArgumentException("List of cookies may not be empty");
        }
        if (cookies.size() > 1) {
            cookies = new ArrayList<Cookie>(cookies);
            Collections.sort(cookies, PATH_COMPARATOR);
        }
        if (this.oneHeader) {
            return this.doFormatOneHeader(cookies);
        }
        return this.doFormatManyHeaders(cookies);
    }

    private List<Header> doFormatOneHeader(List<Cookie> cookies) {
        int version = Integer.MAX_VALUE;
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(40 * cookies.size());
        buffer2.append("Cookie");
        buffer2.append(": ");
        buffer2.append("$Version=");
        buffer2.append(Integer.toString(version));
        for (Cookie cooky : cookies) {
            buffer2.append("; ");
            Cookie cookie = cooky;
            this.formatCookieAsVer(buffer2, cookie, version);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer2));
        return headers;
    }

    private List<Header> doFormatManyHeaders(List<Cookie> cookies) {
        ArrayList<Header> headers = new ArrayList<Header>(cookies.size());
        for (Cookie cookie : cookies) {
            int version = cookie.getVersion();
            CharArrayBuffer buffer2 = new CharArrayBuffer(40);
            buffer2.append("Cookie: ");
            buffer2.append("$Version=");
            buffer2.append(Integer.toString(version));
            buffer2.append("; ");
            this.formatCookieAsVer(buffer2, cookie, version);
            headers.add(new BufferedHeader(buffer2));
        }
        return headers;
    }

    protected void formatParamAsVer(CharArrayBuffer buffer2, String name2, String value2, int version) {
        buffer2.append(name2);
        buffer2.append("=");
        if (value2 != null) {
            if (version > 0) {
                buffer2.append('\"');
                buffer2.append(value2);
                buffer2.append('\"');
            } else {
                buffer2.append(value2);
            }
        }
    }

    protected void formatCookieAsVer(CharArrayBuffer buffer2, Cookie cookie, int version) {
        this.formatParamAsVer(buffer2, cookie.getName(), cookie.getValue(), version);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("path")) {
            buffer2.append("; ");
            this.formatParamAsVer(buffer2, "$Path", cookie.getPath(), version);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            buffer2.append("; ");
            this.formatParamAsVer(buffer2, "$Domain", cookie.getDomain(), version);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "rfc2109";
    }
}

