/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpParams;

public final class DefaultedHttpParams
extends AbstractHttpParams {
    private final HttpParams local;
    private final HttpParams defaults;

    public DefaultedHttpParams(HttpParams local2, HttpParams defaults) {
        if (local2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.local = local2;
        this.defaults = defaults;
    }

    public HttpParams copy() {
        HttpParams clone2 = this.local.copy();
        return new DefaultedHttpParams(clone2, this.defaults);
    }

    public Object getParameter(String name2) {
        Object obj2 = this.local.getParameter(name2);
        if (obj2 == null && this.defaults != null) {
            obj2 = this.defaults.getParameter(name2);
        }
        return obj2;
    }

    public boolean removeParameter(String name2) {
        return this.local.removeParameter(name2);
    }

    public HttpParams setParameter(String name2, Object value2) {
        return this.local.setParameter(name2, value2);
    }

    public HttpParams getDefaults() {
        return this.defaults;
    }
}

