/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Send and receive SMS messages using a SMSC (Short Message Service Center).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SmppEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SMPP component.
     */
    public interface SmppEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSmppEndpointConsumerBuilder advanced() {
            return (AdvancedSmppEndpointConsumerBuilder) this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointConsumerBuilder initialReconnectDelay(
                long initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointConsumerBuilder initialReconnectDelay(
                String initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointConsumerBuilder maxReconnect(int maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointConsumerBuilder maxReconnect(String maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointConsumerBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointConsumerBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option is a:
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointConsumerBuilder splittingPolicy(
                SmppSplittingPolicy splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointConsumerBuilder splittingPolicy(
                String splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * This parameter is used to categorize the type of ESME (External Short
         * Message Entity) that is binding to the SMSC (max. 13 characters).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SmppEndpointConsumerBuilder systemType(String systemType) {
            doSetProperty("systemType", systemType);
            return this;
        }
        /**
         * You can specify the address range for the SmppConsumer as defined in
         * section 5.2.7 of the SMPP 3.4 specification. The SmppConsumer will
         * receive messages only from SMSC's which target an address (MSISDN or
         * IP address) within this range.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default SmppEndpointConsumerBuilder addressRange(String addressRange) {
            doSetProperty("addressRange", addressRange);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SmppEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SmppEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointConsumerBuilder alphabet(byte alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointConsumerBuilder alphabet(String alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointConsumerBuilder dataCoding(byte dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointConsumerBuilder dataCoding(String dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the encoding scheme of the short message user data. Only for
         * SubmitSm, ReplaceSm and SubmitMulti.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ISO-8859-1
         * Group: codec
         */
        default SmppEndpointConsumerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the hostname or ip address of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder httpProxyHost(String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the password required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder httpProxyPort(Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder httpProxyPort(String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the username required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder httpProxyUsername(
                String httpProxyUsername) {
            doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder proxyHeaders(
                Map<String, String> proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: proxy
         */
        default SmppEndpointConsumerBuilder proxyHeaders(String proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * The password for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SmppEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The system id (username) for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: smppclient
         * Group: security
         */
        default SmppEndpointConsumerBuilder systemId(String systemId) {
            doSetProperty("systemId", systemId);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointConsumerBuilder usingSSL(boolean usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointConsumerBuilder usingSSL(String usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SMPP component.
     */
    public interface AdvancedSmppEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SmppEndpointConsumerBuilder basic() {
            return (SmppEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSmppEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSmppEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSmppEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSmppEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder enquireLinkTimer(
                Integer enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder enquireLinkTimer(
                String enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option is a: <code>org.jsmpp.session.SessionStateListener</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder sessionStateListener(
                Object sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option will be converted to a
         * <code>org.jsmpp.session.SessionStateListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder sessionStateListener(
                String sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder transactionTimer(
                Integer transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointConsumerBuilder transactionTimer(
                String transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SMPP component.
     */
    public interface SmppEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSmppEndpointProducerBuilder advanced() {
            return (AdvancedSmppEndpointProducerBuilder) this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointProducerBuilder initialReconnectDelay(
                long initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointProducerBuilder initialReconnectDelay(
                String initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointProducerBuilder maxReconnect(int maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointProducerBuilder maxReconnect(String maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointProducerBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointProducerBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option is a:
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointProducerBuilder splittingPolicy(
                SmppSplittingPolicy splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointProducerBuilder splittingPolicy(
                String splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * This parameter is used to categorize the type of ESME (External Short
         * Message Entity) that is binding to the SMSC (max. 13 characters).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SmppEndpointProducerBuilder systemType(String systemType) {
            doSetProperty("systemType", systemType);
            return this;
        }
        /**
         * Defines the destination SME address. For mobile terminated messages,
         * this is the directory number of the recipient MS. Only for SubmitSm,
         * SubmitMulti, CancelSm and DataSm.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1717
         * Group: producer
         */
        default SmppEndpointProducerBuilder destAddr(String destAddr) {
            doSetProperty("destAddr", destAddr);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following NPI values are defined: 0: Unknown 1: ISDN
         * (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8:
         * National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to
         * be defined by WAP Forum).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder destAddrNpi(byte destAddrNpi) {
            doSetProperty("destAddrNpi", destAddrNpi);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following NPI values are defined: 0: Unknown 1: ISDN
         * (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8:
         * National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to
         * be defined by WAP Forum).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder destAddrNpi(String destAddrNpi) {
            doSetProperty("destAddrNpi", destAddrNpi);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following TON values are defined: 0: Unknown 1:
         * International 2: National 3: Network Specific 4: Subscriber Number 5:
         * Alphanumeric 6: Abbreviated.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder destAddrTon(byte destAddrTon) {
            doSetProperty("destAddrTon", destAddrTon);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following TON values are defined: 0: Unknown 1:
         * International 2: National 3: Network Specific 4: Subscriber Number 5:
         * Alphanumeric 6: Abbreviated.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder destAddrTon(String destAddrTon) {
            doSetProperty("destAddrTon", destAddrTon);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the SMSC is
         * not available when the Camel producer is started. Camel will check
         * the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of
         * the first exchange. If they are present, Camel will use these data to
         * connect to the SMSC.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SmppEndpointProducerBuilder lazySessionCreation(
                boolean lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the SMSC is
         * not available when the Camel producer is started. Camel will check
         * the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of
         * the first exchange. If they are present, Camel will use these data to
         * connect to the SMSC.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SmppEndpointProducerBuilder lazySessionCreation(
                String lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SmppEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SmppEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME. The
         * following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2:
         * Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9:
         * Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined
         * by WAP Forum).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder numberingPlanIndicator(
                byte numberingPlanIndicator) {
            doSetProperty("numberingPlanIndicator", numberingPlanIndicator);
            return this;
        }
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME. The
         * following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2:
         * Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9:
         * Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined
         * by WAP Forum).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder numberingPlanIndicator(
                String numberingPlanIndicator) {
            doSetProperty("numberingPlanIndicator", numberingPlanIndicator);
            return this;
        }
        /**
         * Allows the originating SME to assign a priority level to the short
         * message. Only for SubmitSm and SubmitMulti. Four Priority Levels are
         * supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level
         * 2 priority 3: Level 3 (highest) priority.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder priorityFlag(byte priorityFlag) {
            doSetProperty("priorityFlag", priorityFlag);
            return this;
        }
        /**
         * Allows the originating SME to assign a priority level to the short
         * message. Only for SubmitSm and SubmitMulti. Four Priority Levels are
         * supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level
         * 2 priority 3: Level 3 (highest) priority.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder priorityFlag(String priorityFlag) {
            doSetProperty("priorityFlag", priorityFlag);
            return this;
        }
        /**
         * The protocol id.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder protocolId(byte protocolId) {
            doSetProperty("protocolId", protocolId);
            return this;
        }
        /**
         * The protocol id.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder protocolId(String protocolId) {
            doSetProperty("protocolId", protocolId);
            return this;
        }
        /**
         * Is used to request an SMSC delivery receipt and/or SME originated
         * acknowledgements. The following values are defined: 0: No SMSC
         * delivery receipt requested. 1: SMSC delivery receipt requested where
         * final delivery outcome is success or failure. 2: SMSC delivery
         * receipt requested where the final delivery outcome is delivery
         * failure.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder registeredDelivery(
                byte registeredDelivery) {
            doSetProperty("registeredDelivery", registeredDelivery);
            return this;
        }
        /**
         * Is used to request an SMSC delivery receipt and/or SME originated
         * acknowledgements. The following values are defined: 0: No SMSC
         * delivery receipt requested. 1: SMSC delivery receipt requested where
         * final delivery outcome is success or failure. 2: SMSC delivery
         * receipt requested where the final delivery outcome is delivery
         * failure.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder registeredDelivery(
                String registeredDelivery) {
            doSetProperty("registeredDelivery", registeredDelivery);
            return this;
        }
        /**
         * Used to request the SMSC to replace a previously submitted message,
         * that is still pending delivery. The SMSC will replace an existing
         * message provided that the source address, destination address and
         * service type match the same fields in the new message. The following
         * replace if present flag values are defined: 0: Don't replace 1:
         * Replace.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder replaceIfPresentFlag(
                byte replaceIfPresentFlag) {
            doSetProperty("replaceIfPresentFlag", replaceIfPresentFlag);
            return this;
        }
        /**
         * Used to request the SMSC to replace a previously submitted message,
         * that is still pending delivery. The SMSC will replace an existing
         * message provided that the source address, destination address and
         * service type match the same fields in the new message. The following
         * replace if present flag values are defined: 0: Don't replace 1:
         * Replace.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder replaceIfPresentFlag(
                String replaceIfPresentFlag) {
            doSetProperty("replaceIfPresentFlag", replaceIfPresentFlag);
            return this;
        }
        /**
         * The service type parameter can be used to indicate the SMS
         * Application service associated with the message. The following
         * generic service_types are defined: CMT: Cellular Messaging CPT:
         * Cellular Paging VMN: Voice Mail Notification VMA: Voice Mail Alerting
         * WAP: Wireless Application Protocol USSD: Unstructured Supplementary
         * Services Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder serviceType(String serviceType) {
            doSetProperty("serviceType", serviceType);
            return this;
        }
        /**
         * Defines the address of SME (Short Message Entity) which originated
         * this message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1616
         * Group: producer
         */
        default SmppEndpointProducerBuilder sourceAddr(String sourceAddr) {
            doSetProperty("sourceAddr", sourceAddr);
            return this;
        }
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME
         * originator address parameters. The following NPI values are defined:
         * 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6:
         * Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet
         * (IP) 18: WAP Client Id (to be defined by WAP Forum).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder sourceAddrNpi(byte sourceAddrNpi) {
            doSetProperty("sourceAddrNpi", sourceAddrNpi);
            return this;
        }
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME
         * originator address parameters. The following NPI values are defined:
         * 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6:
         * Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet
         * (IP) 18: WAP Client Id (to be defined by WAP Forum).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder sourceAddrNpi(String sourceAddrNpi) {
            doSetProperty("sourceAddrNpi", sourceAddrNpi);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME originator
         * address parameters. The following TON values are defined: 0: Unknown
         * 1: International 2: National 3: Network Specific 4: Subscriber Number
         * 5: Alphanumeric 6: Abbreviated.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder sourceAddrTon(byte sourceAddrTon) {
            doSetProperty("sourceAddrTon", sourceAddrTon);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME originator
         * address parameters. The following TON values are defined: 0: Unknown
         * 1: International 2: National 3: Network Specific 4: Subscriber Number
         * 5: Alphanumeric 6: Abbreviated.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder sourceAddrTon(String sourceAddrTon) {
            doSetProperty("sourceAddrTon", sourceAddrTon);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME. The following
         * TON values are defined: 0: Unknown 1: International 2: National 3:
         * Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder typeOfNumber(byte typeOfNumber) {
            doSetProperty("typeOfNumber", typeOfNumber);
            return this;
        }
        /**
         * Defines the type of number (TON) to be used in the SME. The following
         * TON values are defined: 0: Unknown 1: International 2: National 3:
         * Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: producer
         */
        default SmppEndpointProducerBuilder typeOfNumber(String typeOfNumber) {
            doSetProperty("typeOfNumber", typeOfNumber);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointProducerBuilder alphabet(byte alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointProducerBuilder alphabet(String alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointProducerBuilder dataCoding(byte dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointProducerBuilder dataCoding(String dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the encoding scheme of the short message user data. Only for
         * SubmitSm, ReplaceSm and SubmitMulti.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ISO-8859-1
         * Group: codec
         */
        default SmppEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the hostname or ip address of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointProducerBuilder httpProxyHost(String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the password required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointProducerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointProducerBuilder httpProxyPort(Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointProducerBuilder httpProxyPort(String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the username required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointProducerBuilder httpProxyUsername(
                String httpProxyUsername) {
            doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointProducerBuilder proxyHeaders(
                Map<String, String> proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: proxy
         */
        default SmppEndpointProducerBuilder proxyHeaders(String proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * The password for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SmppEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The system id (username) for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: smppclient
         * Group: security
         */
        default SmppEndpointProducerBuilder systemId(String systemId) {
            doSetProperty("systemId", systemId);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointProducerBuilder usingSSL(boolean usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointProducerBuilder usingSSL(String usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SMPP component.
     */
    public interface AdvancedSmppEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SmppEndpointProducerBuilder basic() {
            return (SmppEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder enquireLinkTimer(
                Integer enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder enquireLinkTimer(
                String enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option is a: <code>org.jsmpp.session.SessionStateListener</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder sessionStateListener(
                Object sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option will be converted to a
         * <code>org.jsmpp.session.SessionStateListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder sessionStateListener(
                String sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder transactionTimer(
                Integer transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointProducerBuilder transactionTimer(
                String transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SMPP component.
     */
    public interface SmppEndpointBuilder
            extends
                SmppEndpointConsumerBuilder,
                SmppEndpointProducerBuilder {
        default AdvancedSmppEndpointBuilder advanced() {
            return (AdvancedSmppEndpointBuilder) this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointBuilder initialReconnectDelay(
                long initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointBuilder initialReconnectDelay(
                String initialReconnectDelay) {
            doSetProperty("initialReconnectDelay", initialReconnectDelay);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointBuilder maxReconnect(int maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: common
         */
        default SmppEndpointBuilder maxReconnect(String maxReconnect) {
            doSetProperty("maxReconnect", maxReconnect);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default SmppEndpointBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option is a:
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointBuilder splittingPolicy(
                SmppSplittingPolicy splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * You can specify a policy for handling long messages: ALLOW - the
         * default, long messages are split to 140 bytes per message TRUNCATE -
         * long messages are split and only the first fragment will be sent to
         * the SMSC. Some carriers drop subsequent fragments so this reduces
         * load on the SMPP connection sending parts of a message that will
         * never be delivered. REJECT - if a message would need to be split, it
         * is rejected with an SMPP NegativeResponseException and the reason
         * code signifying the message is too long.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code>
         * type.
         * 
         * Default: ALLOW
         * Group: common
         */
        default SmppEndpointBuilder splittingPolicy(String splittingPolicy) {
            doSetProperty("splittingPolicy", splittingPolicy);
            return this;
        }
        /**
         * This parameter is used to categorize the type of ESME (External Short
         * Message Entity) that is binding to the SMSC (max. 13 characters).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SmppEndpointBuilder systemType(String systemType) {
            doSetProperty("systemType", systemType);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointBuilder alphabet(byte alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2
         * Alphabet.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointBuilder alphabet(String alphabet) {
            doSetProperty("alphabet", alphabet);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointBuilder dataCoding(byte dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin
         * 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2
         * (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990).
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: codec
         */
        default SmppEndpointBuilder dataCoding(String dataCoding) {
            doSetProperty("dataCoding", dataCoding);
            return this;
        }
        /**
         * Defines the encoding scheme of the short message user data. Only for
         * SubmitSm, ReplaceSm and SubmitMulti.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ISO-8859-1
         * Group: codec
         */
        default SmppEndpointBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the hostname or ip address of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointBuilder httpProxyHost(String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the password required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointBuilder httpProxyPassword(String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointBuilder httpProxyPort(Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 3128
         * Group: proxy
         */
        default SmppEndpointBuilder httpProxyPort(String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the username required for your HTTP proxy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointBuilder httpProxyUsername(String httpProxyUsername) {
            doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: proxy
         */
        default SmppEndpointBuilder proxyHeaders(
                Map<String, String> proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: proxy
         */
        default SmppEndpointBuilder proxyHeaders(String proxyHeaders) {
            doSetProperty("proxyHeaders", proxyHeaders);
            return this;
        }
        /**
         * The password for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SmppEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The system id (username) for connecting to SMSC server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: smppclient
         * Group: security
         */
        default SmppEndpointBuilder systemId(String systemId) {
            doSetProperty("systemId", systemId);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointBuilder usingSSL(boolean usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
        /**
         * Whether using SSL with the smpps protocol.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SmppEndpointBuilder usingSSL(String usingSSL) {
            doSetProperty("usingSSL", usingSSL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SMPP component.
     */
    public interface AdvancedSmppEndpointBuilder
            extends
                AdvancedSmppEndpointConsumerBuilder,
                AdvancedSmppEndpointProducerBuilder {
        default SmppEndpointBuilder basic() {
            return (SmppEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder enquireLinkTimer(
                Integer enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5000
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder enquireLinkTimer(
                String enquireLinkTimer) {
            doSetProperty("enquireLinkTimer", enquireLinkTimer);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option is a: <code>org.jsmpp.session.SessionStateListener</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder sessionStateListener(
                Object sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         * 
         * The option will be converted to a
         * <code>org.jsmpp.session.SessionStateListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder sessionStateListener(
                String sessionStateListener) {
            doSetProperty("sessionStateListener", sessionStateListener);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder transactionTimer(
                Integer transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedSmppEndpointBuilder transactionTimer(
                String transactionTimer) {
            doSetProperty("transactionTimer", transactionTimer);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.smpp.SmppSplittingPolicy</code> enum.
     */
    enum SmppSplittingPolicy {
        ALLOW,
        REJECT,
        TRUNCATE;
    }

    public interface SmppBuilders {
        /**
         * SMPP (camel-smpp)
         * Send and receive SMS messages using a SMSC (Short Message Service
         * Center).
         * 
         * Category: mobile
         * Since: 2.2
         * Maven coordinates: org.apache.camel:camel-smpp
         * 
         * Syntax: <code>smpp:host:port</code>
         * 
         * Path parameter: host
         * Hostname for the SMSC server to use.
         * Default value: localhost
         * 
         * Path parameter: port
         * Port number for the SMSC server to use.
         * Default value: 2775
         * 
         * @param path host:port
         */
        default SmppEndpointBuilder smpp(String path) {
            return SmppEndpointBuilderFactory.endpointBuilder("smpp", path);
        }
        /**
         * SMPP (camel-smpp)
         * Send and receive SMS messages using a SMSC (Short Message Service
         * Center).
         * 
         * Category: mobile
         * Since: 2.2
         * Maven coordinates: org.apache.camel:camel-smpp
         * 
         * Syntax: <code>smpp:host:port</code>
         * 
         * Path parameter: host
         * Hostname for the SMSC server to use.
         * Default value: localhost
         * 
         * Path parameter: port
         * Port number for the SMSC server to use.
         * Default value: 2775
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port
         */
        default SmppEndpointBuilder smpp(String componentName, String path) {
            return SmppEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * SMPP (Secure) (camel-smpp)
         * Send and receive SMS messages using a SMSC (Short Message Service
         * Center).
         * 
         * Category: mobile
         * Since: 2.2
         * Maven coordinates: org.apache.camel:camel-smpp
         * 
         * Syntax: <code>smpps:host:port</code>
         * 
         * Path parameter: host
         * Hostname for the SMSC server to use.
         * Default value: localhost
         * 
         * Path parameter: port
         * Port number for the SMSC server to use.
         * Default value: 2775
         * 
         * @param path host:port
         */
        default SmppEndpointBuilder smpps(String path) {
            return SmppEndpointBuilderFactory.endpointBuilder("smpps", path);
        }
    }
    static SmppEndpointBuilder endpointBuilder(String componentName, String path) {
        class SmppEndpointBuilderImpl extends AbstractEndpointBuilder implements SmppEndpointBuilder, AdvancedSmppEndpointBuilder {
            public SmppEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SmppEndpointBuilderImpl(path);
    }
}