/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.as2;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAs2SinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AS2_PATH_API_NAME_CONF = "camel.sink.path.apiName";
    public static final String CAMEL_SINK_AS2_PATH_API_NAME_DOC = "What kind of operation to perform One of: [CLIENT] [SERVER]";
    public static final String CAMEL_SINK_AS2_PATH_API_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_PATH_METHOD_NAME_CONF = "camel.sink.path.methodName";
    public static final String CAMEL_SINK_AS2_PATH_METHOD_NAME_DOC = "What sub operation to use for the selected operation";
    public static final String CAMEL_SINK_AS2_PATH_METHOD_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_CONF = "camel.sink.endpoint.as2From";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_DOC = "The value of the AS2From header of AS2 message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_CONF = "camel.sink.endpoint.as2MessageStructure";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_DOC = "The structure of AS2 Message. One of: PLAIN - No encryption, no signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption, no signature, ENCRYPTED_SIGNED - Encryption, signature One of: [PLAIN] [SIGNED] [ENCRYPTED] [SIGNED_ENCRYPTED] [PLAIN_COMPRESSED] [SIGNED_COMPRESSED] [ENCRYPTED_COMPRESSED] [ENCRYPTED_COMPRESSED_SIGNED]";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2TO_CONF = "camel.sink.endpoint.as2To";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2TO_DOC = "The value of the AS2To header of AS2 message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2TO_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_CONF = "camel.sink.endpoint.as2Version";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_DOC = "The version of the AS2 protocol. One of: [1.0] [1.1]";
    public static final String CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_DEFAULT = "1.1";
    public static final String CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_CONF = "camel.sink.endpoint.clientFqdn";
    public static final String CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_DOC = "The Client Fully Qualified Domain Name (FQDN). Used in message ids sent by endpoint.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_DEFAULT = "camel.apache.org";
    public static final String CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_CONF = "camel.sink.endpoint.compressionAlgorithm";
    public static final String CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_DOC = "The algorithm used to compress EDI message. One of: [ZLIB]";
    public static final String CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_CONF = "camel.sink.endpoint.decryptingPrivateKey";
    public static final String CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_DOC = "The key used to encrypt the EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_CONF = "camel.sink.endpoint.dispositionNotificationTo";
    public static final String CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_DOC = "The value of the Disposition-Notification-To header. Assigning a value to this parameter requests a message disposition notification (MDN) for the AS2 message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_CONF = "camel.sink.endpoint.ediMessageTransferEncoding";
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_DOC = "The transfer encoding of EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_CONF = "camel.sink.endpoint.ediMessageType";
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_DOC = "The content type of EDI message. One of application/edifact, application/edi-x12, application/edi-consent";
    public static final String CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_CONF = "camel.sink.endpoint.encryptingAlgorithm";
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_DOC = "The algorithm used to encrypt EDI message. One of: [AES128_CBC] [AES192_CBC] [AES256_CBC] [AES128_CCM] [AES192_CCM] [AES256_CCM] [AES128_GCM] [AES192_GCM] [AES256_GCM] [CAMELLIA128_CBC] [CAMELLIA192_CBC] [CAMELLIA256_CBC] [CAST5_CBC] [DES_CBC] [DES_EDE3_CBC] [GOST28147_GCFB] [IDEA_CBC] [RC2_CBC] [RC4] [SEED_CBC]";
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_CONF = "camel.sink.endpoint.encryptingCertificateChain";
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_DOC = "The chain of certificates used to encrypt EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_FROM_CONF = "camel.sink.endpoint.from";
    public static final String CAMEL_SINK_AS2_ENDPOINT_FROM_DOC = "The value of the From header of AS2 message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_FROM_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_IN_BODY_CONF = "camel.sink.endpoint.inBody";
    public static final String CAMEL_SINK_AS2_ENDPOINT_IN_BODY_DOC = "Sets the name of a parameter to be passed in the exchange In Body";
    public static final String CAMEL_SINK_AS2_ENDPOINT_IN_BODY_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_CONF = "camel.sink.endpoint.mdnMessageTemplate";
    public static final String CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_DOC = "The template used to format MDN message";
    public static final String CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_CONF = "camel.sink.endpoint.requestUri";
    public static final String CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_DOC = "The request URI of EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_DEFAULT = "/";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_CONF = "camel.sink.endpoint.server";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_DOC = "The value included in the Server message header identifying the AS2 Server.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_DEFAULT = "Camel AS2 Server Endpoint";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_CONF = "camel.sink.endpoint.serverFqdn";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_DOC = "The Server Fully Qualified Domain Name (FQDN). Used in message ids sent by endpoint.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_DEFAULT = "camel.apache.org";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_CONF = "camel.sink.endpoint.serverPortNumber";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_DOC = "The port number of server.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_CONF = "camel.sink.endpoint.signedReceiptMicAlgorithms";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_DOC = "The list of algorithms, in order of preference, requested to generate a message integrity check (MIC) returned in message dispostion notification (MDN)";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_CONF = "camel.sink.endpoint.signingAlgorithm";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_DOC = "The algorithm used to sign EDI message. One of: [SHA3_224WITHRSA] [SHA3_256WITHRSA] [SHA3_384withRSA] [SHA3_512WITHRSA] [MD5WITHRSA] [SHA1WITHRSA] [MD2WITHRSA] [SHA224WITHRSA] [SHA256WITHRSA] [SHA384WITHRSA] [SHA512WITHRSA] [RIPEMD128WITHRSA] [RIPEMD160WITHRSA] [RIPEMD256WITHRSA] [SHA224WITHDSA] [SHA256WITHDSA] [SHA384WITHDSA] [SHA512WITHDSA] [SHA3_224WITHDSA] [SHA3_256WITHDSA] [SHA3_384WITHDSA] [SHA3_512WITHDSA] [SHA1WITHDSA] [SHA3_224WITHECDSA] [SHA3_256WITHECDSA] [SHA3_384WITHECDSA] [SHA3_512WITHECDSA] [SHA1WITHECDSA] [SHA224WITHECDSA] [SHA256WITHECDSA] [SHA384WITHECDSA] [SHA512WITHECDSA] [SHA1WITHPLAIN_ECDSA] [SHA224WITHPLAIN_ECDSA] [SHA256WITHPLAIN_ECDSA] [SHA384WITHPLAIN_ECDSA] [SHA512WITHPLAIN_ECDSA] [RIPEMD160WITHPLAIN_ECDSA] [SHA1WITHRSAANDMGF1] [SHA224WITHRSAANDMGF1] [SHA256WITHRSAANDMGF1] [SHA384WITHRSAANDMGF1] [SHA512WITHRSAANDMGF1] [SHA3_224WITHRSAANDMGF1] [SHA3_256WITHRSAANDMGF1] [SHA3_384WITHRSAANDMGF1] [SHA3_512WITHRSAANDMGF1]";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_CONF = "camel.sink.endpoint.signingCertificateChain";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_DOC = "The chain of certificates used to sign EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_CONF = "camel.sink.endpoint.signingPrivateKey";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_DOC = "The key used to sign the EDI message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SUBJECT_CONF = "camel.sink.endpoint.subject";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SUBJECT_DOC = "The value of Subject header of AS2 message.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SUBJECT_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_CONF = "camel.sink.endpoint.targetHostname";
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_DOC = "The host name (IP or DNS name) of target host.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_CONF = "camel.sink.endpoint.targetPortNumber";
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_DOC = "The port number of target host. -1 indicates the scheme default port.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_CONF = "camel.sink.endpoint.userAgent";
    public static final String CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_DOC = "The value included in the User-Agent message header identifying the AS2 user agent.";
    public static final String CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_DEFAULT = "Camel AS2 Client Endpoint";
    public static final String CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_CONF = "camel.component.as2.configuration";
    public static final String CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_DOC = "To use the shared configuration";
    public static final String CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.as2.lazyStartProducer";
    public static final String CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.as2.basicPropertyBinding";
    public static final String CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelAs2SinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAs2SinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AS2_PATH_API_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_PATH_API_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AS2_PATH_API_NAME_DOC);
        conf.define(CAMEL_SINK_AS2_PATH_METHOD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_PATH_METHOD_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AS2_PATH_METHOD_NAME_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_AS_2FROM_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_AS_2MESSAGE_STRUCTURE_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_AS_2TO_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_AS_2TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_AS_2TO_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_AS_2VERSION_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_CLIENT_FQDN_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_COMPRESSION_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_DECRYPTING_PRIVATE_KEY_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_DISPOSITION_NOTIFICATION_TO_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TRANSFER_ENCODING_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_EDI_MESSAGE_TYPE_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_ENCRYPTING_CERTIFICATE_CHAIN_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_FROM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_FROM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_FROM_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_IN_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_IN_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_IN_BODY_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_MDN_MESSAGE_TEMPLATE_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_REQUEST_URI_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SERVER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SERVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SERVER_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SERVER_FQDN_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SERVER_PORT_NUMBER_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SIGNED_RECEIPT_MIC_ALGORITHMS_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SIGNING_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SIGNING_CERTIFICATE_CHAIN_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SIGNING_PRIVATE_KEY_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SUBJECT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_SUBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SUBJECT_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_TARGET_HOSTNAME_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_TARGET_PORT_NUMBER_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_USER_AGENT_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AS2_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}