/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.debeziummysql;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDebeziummysqlSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_CONF = "camel.source.path.name";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_DOC = "Unique name for the connector. Attempting to register again with the same name will fail.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.source.endpoint.additionalProperties";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF = "camel.source.endpoint.internalKeyConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF = "camel.source.endpoint.internalValueConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_CONF = "camel.source.endpoint.offsetCommitPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_DOC = "The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT = "io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF = "camel.source.endpoint.offsetCommitTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF = "camel.source.endpoint.offsetFlushIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC = "Interval at which to try committing offsets. The default is 1 minute.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_CONF = "camel.source.endpoint.offsetStorage";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_DOC = "The name of the Java class that is responsible for persistence of connector offsets.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_DEFAULT = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF = "camel.source.endpoint.offsetStorageFileName";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC = "Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF = "camel.source.endpoint.offsetStoragePartitions";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC = "The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF = "camel.source.endpoint.offsetStorageReplicationFactor";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC = "Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF = "camel.source.endpoint.offsetStorageTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC = "The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_CONF = "camel.source.endpoint.bigintUnsignedHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_DOC = "Specify how BIGINT UNSIGNED columns should be represented in change events, including:'precise' uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'long' (the default) represents values using Java's 'long', which may not offer the precision but will be far easier to use in consumers.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_DEFAULT = "long";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_CONF = "camel.source.endpoint.binlogBufferSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_DOC = "The size of a look-ahead buffer used by the binlog reader to decide whether the transaction in progress is going to be committed or rolled back. Use 0 to disable look-ahead buffering. Defaults to 0 (i.e. buffering is disabled).";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_CONF = "camel.source.endpoint.columnBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'column.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_CONF = "camel.source.endpoint.connectKeepAlive";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_DOC = "Whether a separate thread should be used to ensure the connection is kept alive.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_CONF = "camel.source.endpoint.connectKeepAliveIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_DOC = "Interval in milliseconds to wait for connection checking if keep alive thread is used.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_CONF = "camel.source.endpoint.connectTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_DOC = "Maximum time in milliseconds to wait after trying to connect to the database before timing out.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_DEFAULT = 30000;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_CONF = "camel.source.endpoint.databaseBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'database.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_CONF = "camel.source.endpoint.databaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_DOC = "The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_DEFAULT = "io.debezium.relational.history.FileDatabaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF = "camel.source.endpoint.databaseHistoryFileFilename";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC = "The path to the file that will be used to record the database history";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF = "camel.source.endpoint.databaseHistoryKafkaBootstrapServers";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs that the connector will use for establishing the initial connection to the Kafka cluster for retrieving database schema history previously stored by the connector. This should point to the same Kafka cluster used by the Kafka Connect process.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF = "camel.source.endpoint.databaseHistoryKafkaRecoveryAttempts";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC = "The number of attempts in a row that no data are returned from Kafka before recover completes. The maximum amount of time to wait after receiving no data is (recovery.attempts) x (recovery.poll.interval.ms).";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.databaseHistoryKafkaRecoveryPollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC = "The number of milliseconds to wait while polling for persisted data during recovery.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_CONF = "camel.source.endpoint.databaseHistoryKafkaTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DOC = "The name of the topic for the database schema history";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_CONF = "camel.source.endpoint.databaseHistorySkipUnparseableDdl";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_DOC = "Controls the action Debezium will take when it meets a DDL statement in binlog, that it cannot parse.By default the connector will stop operating but by changing the setting it can ignore the statements which it cannot parse. If skipping is enabled then Debezium can miss metadata changes.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_CONF = "camel.source.endpoint.databaseHistoryStoreOnlyMonitoredTablesDdl";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_DOC = "Controls what DDL will Debezium store in database history.By default (false) Debezium will store all incoming DDL statements. If set to truethen only DDL that manipulates a monitored table will be stored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_CONF = "camel.source.endpoint.databaseHostname";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_DOC = "Resolvable hostname or IP address of the MySQL database server.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_CONF = "camel.source.endpoint.databaseInitialStatements";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DOC = "A semicolon separated list of SQL statements to be executed when a JDBC connection (not binlog reading connection) to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configuration of session parameters only,but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_CONF = "camel.source.endpoint.databaseJdbcDriver";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_DOC = "JDBC Driver class name used to connect to the MySQL database server.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_DEFAULT = "class com.mysql.cj.jdbc.Driver";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_CONF = "camel.source.endpoint.databasePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_DOC = "Password of the MySQL database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_CONF = "camel.source.endpoint.databasePort";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_DOC = "Port of the MySQL database server.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_DEFAULT = 3306;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_CONF = "camel.source.endpoint.databaseServerId";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_DOC = "A numeric ID of this database client, which must be unique across all currently-running database processes in the cluster. This connector joins the MySQL database cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_CONF = "camel.source.endpoint.databaseServerIdOffset";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_DOC = "Only relevant if parallel snapshotting is configured. During parallel snapshotting, multiple (4) connections open to the database client, and they each need their own unique connection ID. This offset is used to generate those IDs from the base configured cluster ID.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_CONF = "camel.source.endpoint.databaseServerName";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_DOC = "Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_CONF = "camel.source.endpoint.databaseSslKeystore";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_DOC = "Location of the Java keystore file containing an application process's own certificate and private key.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_CONF = "camel.source.endpoint.databaseSslKeystorePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_DOC = "Password to access the private key from the keystore file specified by 'ssl.keystore' configuration property or the 'javax.net.ssl.keyStore' system or JVM property. This password is used to unlock the keystore file (store password), and to decrypt the private key stored in the keystore (key password).";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_CONF = "camel.source.endpoint.databaseSslMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_DOC = "Whether to use an encrypted connection to MySQL. Options include'disabled' (the default) to use an unencrypted connection; 'preferred' to establish a secure (encrypted) connection if the server supports secure connections, but fall back to an unencrypted connection otherwise; 'required' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify_ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify_identity' like 'verify_ca' but additionally verify that the server certificate matches the host to which the connection is attempted.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_DEFAULT = "disabled";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_CONF = "camel.source.endpoint.databaseSslTruststore";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_DOC = "Location of the Java truststore file containing the collection of CA certificates trusted by this application process (trust store).";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_CONF = "camel.source.endpoint.databaseSslTruststorePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_DOC = "Password to unlock the keystore file (store password) specified by 'ssl.trustore' configuration property or the 'javax.net.ssl.trustStore' system or JVM property.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_CONF = "camel.source.endpoint.databaseUser";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_DOC = "Name of the MySQL database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_CONF = "camel.source.endpoint.databaseWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_DOC = "The databases for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_CONF = "camel.source.endpoint.decimalHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_DOC = "Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT = "precise";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_CONF = "camel.source.endpoint.enableTimeAdjuster";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_DOC = "MySQL allows user to insert year value as either 2-digit or 4-digit. In case of two digit the value is automatically mapped into 1970 - 2069.false - delegates the implicit conversion to the databasetrue - (the default) Debezium makes the conversion";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_CONF = "camel.source.endpoint.eventDeserializationFailureHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_DOC = "Specify how failures during deserialization of binlog events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_DEFAULT = "fail";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_CONF = "camel.source.endpoint.gtidNewChannelPosition";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_DOC = "If set to 'latest', when connector sees new GTID, it will start consuming gtid channel from the server latest executed gtid position. If 'earliest' connector starts reading channel from first available (not purged) gtid position on the server.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_DEFAULT = "latest";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_CONF = "camel.source.endpoint.gtidSourceExcludes";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_DOC = "The source UUIDs used to exclude GTID ranges when determine the starting position in the MySQL server's binlog.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_CONF = "camel.source.endpoint.gtidSourceFilterDmlEvents";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_DOC = "If set to true, we will only produce DML events into Kafka for transactions that were written on mysql servers with UUIDs matching the filters defined by the gtid.source.includes or gtid.source.excludes configuration options, if they are specified.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_CONF = "camel.source.endpoint.gtidSourceIncludes";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_DOC = "The source UUIDs used to include GTID ranges when determine the starting position in the MySQL server's binlog.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF = "camel.source.endpoint.heartbeatIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC = "Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF = "camel.source.endpoint.heartbeatTopicsPrefix";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC = "The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT = "__debezium-heartbeat";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_CONF = "camel.source.endpoint.includeQuery";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_DOC = "Whether the connector should include the original SQL query that generated the change event. Note: This option requires MySQL be configured with the binlog_rows_query_log_events option set to ON. Query will not be present for events generated from snapshot. WARNING: Enabling this option may expose tables or fields explicitly blacklisted or masked by including the original SQL statement in the change event. For this reason the default value is 'false'.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_CONF = "camel.source.endpoint.includeSchemaChanges";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DOC = "Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server ID. Each schema change will be recorded using a key that contains the database name and whose value includes the DDL statement(s).The default is 'true'. This is independent of how the connector internally records database history.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_CONF = "camel.source.endpoint.inconsistentSchemaHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_DOC = "Specify how binlog events that belong to a table missing from internal schema representation (i.e. internal representation is not consistent with database) should be handled, including:'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_DEFAULT = "fail";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_CONF = "camel.source.endpoint.maxBatchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_DOC = "Maximum size of each batch of source records. Defaults to 2048.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_DEFAULT = 2048;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_CONF = "camel.source.endpoint.maxQueueSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_DOC = "Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF = "camel.source.endpoint.messageKeyColumns";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC = "A semicolon-separated list of expressions that match fully-qualified tables and column(s) to be used as message key. Each expression must match the pattern ':',where the table names could be defined as (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the specific connector,and the key columns are a comma-separated list of columns representing the custom key. For any table without an explicit key configuration the table's primary key column(s) will be used as message key.Example: dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.pollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_DOC = "Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_CONF = "camel.source.endpoint.snapshotDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_DOC = "The number of milliseconds to delay before a snapshot will begin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF = "camel.source.endpoint.snapshotFetchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC = "The maximum number of records that should be loaded into memory while performing a snapshot";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_CONF = "camel.source.endpoint.snapshotLockingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_DOC = "Controls how long the connector holds onto the global read lock while it is performing a snapshot. The default is 'minimal', which means the connector holds the global read lock (and thus prevents any updates) for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this can be done using the snapshot process' REPEATABLE READ transaction even when the lock is no longer held and other operations are updating the database. However, in some cases it may be desirable to block all writes for the entire duration of the snapshot; in such cases set this property to 'extended'. Using a value of 'none' will prevent the connector from acquiring any table locks during the snapshot process. This mode can only be used in combination with snapshot.mode values of 'schema_only' or 'schema_only_recovery' and is only safe to use if no schema changes are happening while the snapshot is taken.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_DEFAULT = "minimal";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_CONF = "camel.source.endpoint.snapshotMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_DOC = "The criteria for running a snapshot upon startup of the connector. Options include: 'when_needed' to specify that the connector run a snapshot upon startup whenever it deems it necessary; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally read the binlog; and'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the beginning of the binlog. The 'never' mode should be used with care, and only when the binlog is known to contain all history.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_DEFAULT = "initial";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_CONF = "camel.source.endpoint.snapshotNewTables";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_DOC = "BETA FEATURE: On connector restart, the connector will check if there have been any new tables added to the configuration, and snapshot them. There is presently only two options:'off': Default behavior. Do not snapshot new tables.'parallel': The snapshot of the new tables will occur in parallel to the continued binlog reading of the old tables. When the snapshot completes, an independent binlog reader will begin reading the events for the new tables until it catches up to present time. At this point, both old and new binlog readers will be momentarily halted and new binlog reader will start that will read the binlog for all configured tables. The parallel binlog reader will have a configured server id of 10000 the primary binlog reader's server id.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_DEFAULT = "off";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF = "camel.source.endpoint.snapshotSelectStatementOverrides";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC = "This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_CONF = "camel.source.endpoint.sourceStructVersion";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_DOC = "A version of the format of the publicly visible source part in the message";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT = "v2";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_CONF = "camel.source.endpoint.tableBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'table.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_CONF = "camel.source.endpoint.tableIgnoreBuiltin";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_DOC = "Flag specifying whether built-in tables should be ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_CONF = "camel.source.endpoint.tableWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_DOC = "The tables for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_CONF = "camel.source.endpoint.timePrecisionMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_DOC = "Time, date and timestamps can be represented with different kinds of precisions, including:'adaptive_time_microseconds': the precision of date and timestamp values is based the database column's precision; but time fields always use microseconds precision;'connect': always represents time, date and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_DEFAULT = "adaptive_time_microseconds";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_CONF = "camel.source.endpoint.tombstonesOnDelete";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_DOC = "Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.debezium-mysql.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_CONF = "camel.component.debezium-mysql.configuration";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_DOC = "Allow pre-configured Configurations to be set.";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.debezium-mysql.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelDebeziummysqlSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDebeziummysqlSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMYSQL_PATH_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BIGINT_UNSIGNED_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_BINLOG_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_COLUMN_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_KEEP_ALIVE_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_CONNECT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_SKIP_UNPARSEABLE_DDL_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HISTORY_STORE_ONLY_MONITORED_TABLES_DDL_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_JDBC_DRIVER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_PORT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_ID_OFFSET_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SERVER_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_KEYSTORE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_SSL_TRUSTSTORE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_USER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DATABASE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_DECIMAL_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_ENABLE_TIME_ADJUSTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_NEW_CHANNEL_POSITION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_EXCLUDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_FILTER_DML_EVENTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_GTID_SOURCE_INCLUDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_QUERY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_INCONSISTENT_SCHEMA_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_BATCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MAX_QUEUE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_LOCKING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_NEW_TABLES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_SOURCE_STRUCT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_IGNORE_BUILTIN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TABLE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TIME_PRECISION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_ENDPOINT_TOMBSTONES_ON_DELETE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMYSQL_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}