/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.robotframework;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelRobotframeworkSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_CONF = "camel.source.path.resourceUri";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_DOC = "Path to the resource. You can prefix with: classpath, file, http, ref, or bean. classpath, file and http loads the resource using these protocols (classpath is default). ref will lookup the resource in the registry. bean will call a method on a bean to be used as the resource. For bean you can specify the method name after dot, eg bean:myBean.myMethod.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_CONF = "camel.source.endpoint.argumentFile";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_DOC = "A text file to read more arguments from.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_CONF = "camel.source.endpoint.combinedTagStats";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_DOC = "Creates combined statistics based on tags. Use the format tags:title List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_CONF = "camel.source.endpoint.contentCache";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_DOC = "Sets whether to use resource content cache or not";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_CONF = "camel.source.endpoint.criticalTags";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_DOC = "Tests that have the given tags are considered critical. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_CONF = "camel.source.endpoint.debugFile";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_DOC = "A debug file that is written during execution.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_CONF = "camel.source.endpoint.document";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_DOC = "Sets the documentation of the top-level tests suites.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_CONF = "camel.source.endpoint.dryrun";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_DOC = "Sets dryrun mode on use. In the dry run mode tests are run without executing keywords originating from test libraries. Useful for validating test data syntax.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_CONF = "camel.source.endpoint.excludes";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_DOC = "Selects the tests cases by tags. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_CONF = "camel.source.endpoint.exitOnFailure";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_DOC = "Sets robot to stop execution immediately if a critical test fails.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_CONF = "camel.source.endpoint.includes";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_DOC = "Selects the tests cases by tags. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_CONF = "camel.source.endpoint.listener";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_DOC = "Sets a single listener for monitoring tests execution";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_CONF = "camel.source.endpoint.listeners";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_DOC = "Sets multiple listeners for monitoring tests execution. Use the format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_CONF = "camel.source.endpoint.log";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_DOC = "Sets the path to the generated log file.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_CONF = "camel.source.endpoint.logLevel";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_DOC = "Sets the threshold level for logging.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_CONF = "camel.source.endpoint.logTitle";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_DOC = "Sets a title for the generated tests log.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_CONF = "camel.source.endpoint.metadata";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_DOC = "Sets free metadata for the top level tests suites. comma seperated list of string resulting as List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_CONF = "camel.source.endpoint.monitorColors";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_DOC = "Using ANSI colors in console. Normally colors work in unixes but not in Windows. Default is 'on'. 'on' - use colors in unixes but not in Windows 'off' - never use colors 'force' - always use colors (also in Windows)";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_CONF = "camel.source.endpoint.monitorWidth";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_DOC = "Width of the monitor output. Default is 78.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_DEFAULT = "78";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_CONF = "camel.source.endpoint.name";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_DOC = "Sets the name of the top-level tests suites.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_CONF = "camel.source.endpoint.nonCriticalTags";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_DOC = "Tests that have the given tags are not critical. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_CONF = "camel.source.endpoint.noStatusReturnCode";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_DOC = "If true, sets the return code to zero regardless of failures in test cases. Error codes are returned normally.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_CONF = "camel.source.endpoint.output";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DOC = "Sets the path to the generated output file.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_CONF = "camel.source.endpoint.outputDirectory";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_DOC = "Configures where generated reports are to be placed.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_CONF = "camel.source.endpoint.randomize";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_DOC = "Sets the test execution order to be randomized. Valid values are all, suite, and test";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_CONF = "camel.source.endpoint.report";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_DOC = "Sets the path to the generated report file.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_CONF = "camel.source.endpoint.reportBackground";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_DOC = "Sets background colors for the generated report and summary.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_CONF = "camel.source.endpoint.reportTitle";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_DOC = "Sets a title for the generated tests report.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_CONF = "camel.source.endpoint.runEmptySuite";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_DOC = "Executes tests also if the top level test suite is empty. Useful e.g. with --include/--exclude when it is not an error that no test matches the condition.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_CONF = "camel.source.endpoint.runFailed";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_DOC = "Re-run failed tests, based on output.xml file.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_CONF = "camel.source.endpoint.runMode";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_DOC = "Sets the execution mode for this tests run. Note that this setting has been deprecated in Robot Framework 2.8. Use separate dryryn, skipTeardownOnExit, exitOnFailure, and randomize settings instead.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_CONF = "camel.source.endpoint.skipTeardownOnExit";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_DOC = "Sets whether the teardowns are skipped if the test execution is prematurely stopped.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_CONF = "camel.source.endpoint.splitOutputs";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_DOC = "Splits output and log files.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_CONF = "camel.source.endpoint.suites";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_DOC = "Selects the tests suites by name. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_CONF = "camel.source.endpoint.suiteStatLevel";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_DOC = "Defines how many levels to show in the Statistics by Suite table in outputs.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_CONF = "camel.source.endpoint.summaryTitle";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_DOC = "Sets a title for the generated summary report.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_CONF = "camel.source.endpoint.tagDocs";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_DOC = "Adds documentation to the specified tags. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_CONF = "camel.source.endpoint.tags";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_DOC = "Sets the tags(s) to all executed tests cases. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_CONF = "camel.source.endpoint.tagStatExcludes";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_DOC = "Excludes these tags from the Statistics by Tag and Test Details by Tag tables in outputs. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_CONF = "camel.source.endpoint.tagStatIncludes";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_DOC = "Includes only these tags in the Statistics by Tag and Test Details by Tag tables in outputs. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_CONF = "camel.source.endpoint.tagStatLinks";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_DOC = "Adds external links to the Statistics by Tag table in outputs. Use the format pattern:link:title List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_CONF = "camel.source.endpoint.tests";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_DOC = "Selects the tests cases by name. List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_CONF = "camel.source.endpoint.timestampOutputs";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_DOC = "Adds a timestamp to all output files.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_CONF = "camel.source.endpoint.variableFiles";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_DOC = "Sets variables using variables files. Use the format path:args List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_CONF = "camel.source.endpoint.variables";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_DOC = "Sets individual variables. Use the format name:value List";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_CONF = "camel.source.endpoint.warnOnSkippedFiles";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_DOC = "Show a warning when an invalid file is skipped.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_CONF = "camel.source.endpoint.xunitFile";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_DOC = "Sets the path to the generated XUnit compatible result file, relative to outputDirectory. The file is in xml format. By default, the file name is derived from the testCasesDirectory parameter, replacing blanks in the directory name by underscores.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF = "camel.source.endpoint.sendEmptyMessageWhenIdle";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC = "If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_CONF = "camel.source.endpoint.pollStrategy";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_DOC = "A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF = "camel.source.endpoint.backoffErrorThreshold";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC = "The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF = "camel.source.endpoint.backoffIdleThreshold";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC = "The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_CONF = "camel.source.endpoint.backoffMultiplier";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_DOC = "To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.";
    public static final Integer CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_DOC = "Milliseconds before the next poll. You can also specify time values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).";
    public static final Long CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_CONF = "camel.source.endpoint.greedy";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_DOC = "If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_DOC = "Milliseconds before the first poll starts. You can also specify time values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).";
    public static final Long CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_CONF = "camel.source.endpoint.repeatCount";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_DOC = "Specifies a maximum limit of number of fires. So if you set it to 1, the scheduler will only fire once. If you set it to 5, it will only fire five times. A value of zero or negative means fire forever.";
    public static final Long CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_CONF = "camel.source.endpoint.runLoggingLevel";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_DOC = "The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT = "TRACE";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.scheduledExecutorService";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC = "Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_CONF = "camel.source.endpoint.scheduler";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_DOC = "To use a cron scheduler from either camel-spring or camel-quartz component One of: [none] [spring] [quartz]";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_DEFAULT = "none";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_CONF = "camel.source.endpoint.schedulerProperties";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_DOC = "To configure additional properties when using a custom scheduler or any of the Quartz, Spring based scheduler.";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_CONF = "camel.source.endpoint.startScheduler";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_DOC = "Whether the scheduler should be auto started.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_DEFAULT = true;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_CONF = "camel.source.endpoint.timeUnit";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_DOC = "Time unit for initialDelay and delay options. One of: [NANOSECONDS] [MICROSECONDS] [MILLISECONDS] [SECONDS] [MINUTES] [HOURS] [DAYS]";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_DEFAULT = "MILLISECONDS";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_CONF = "camel.source.endpoint.useFixedDelay";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_DOC = "Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.robotframework.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.robotframework.basicPropertyBinding";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_CONF = "camel.component.robotframework.configuration";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_DOC = "The configuration";
    public static final String CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_DEFAULT = null;

    public CamelRobotframeworkSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelRobotframeworkSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_ROBOTFRAMEWORK_PATH_RESOURCE_URI_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_ARGUMENT_FILE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_COMBINED_TAG_STATS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CONTENT_CACHE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_CRITICAL_TAGS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DEBUG_FILE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DOCUMENT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DRYRUN_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCLUDES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXIT_ON_FAILURE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INCLUDES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LISTENERS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_LOG_TITLE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_METADATA_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_COLORS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_MONITOR_WIDTH_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NAME_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NON_CRITICAL_TAGS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_NO_STATUS_RETURN_CODE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_OUTPUT_DIRECTORY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RANDOMIZE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_BACKGROUND_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPORT_TITLE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_EMPTY_SUITE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_FAILED_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_MODE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SKIP_TEARDOWN_ON_EXIT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SPLIT_OUTPUTS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUITE_STAT_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SUMMARY_TITLE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_DOCS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAGS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_EXCLUDES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_INCLUDES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TAG_STAT_LINKS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TESTS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIMESTAMP_OUTPUTS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLE_FILES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_VARIABLES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_WARN_ON_SKIPPED_FILES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_XUNIT_FILE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_POLL_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_BACKOFF_MULTIPLIER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_GREEDY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_REPEAT_COUNT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_RUN_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_SCHEDULER_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_START_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_TIME_UNIT_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_ENDPOINT_USE_FIXED_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ROBOTFRAMEWORK_COMPONENT_CONFIGURATION_DOC);
        return conf;
    }
}