/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.sparkrest;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSparkrestSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SPARKREST_PATH_VERB_CONF = "camel.source.path.verb";
    public static final String CAMEL_SOURCE_SPARKREST_PATH_VERB_DOC = "get, post, put, patch, delete, head, trace, connect, or options. One of: [get] [post] [put] [patch] [delete] [head] [trace] [connect] [options]";
    public static final String CAMEL_SOURCE_SPARKREST_PATH_VERB_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_PATH_PATH_CONF = "camel.source.path.path";
    public static final String CAMEL_SOURCE_SPARKREST_PATH_PATH_DOC = "The content path which support Spark syntax.";
    public static final String CAMEL_SOURCE_SPARKREST_PATH_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_CONF = "camel.source.endpoint.accept";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_DOC = "Accept type such as: 'text/xml', or 'application/json'. By default we accept all kinds of types.";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_CONF = "camel.source.endpoint.disableStreamCache";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_DOC = "Determines whether or not the raw input stream from Spark HttpRequest#getContent() is cached or not (Camel will read the stream into a in light-weight memory based Stream caching) cache. By default Camel will cache the Netty input stream to support reading it multiple times to ensure Camel can retrieve all data from the stream. However you can set this option to true when you for example need to access the raw stream, such as streaming it directly to a file or other persistent store. Mind that if you enable this option, then you cannot read the Netty stream multiple times out of the box, and you would need manually to reset the reader index on the Spark raw stream.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_CONF = "camel.source.endpoint.mapHeaders";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_DOC = "If this option is enabled, then during binding from Spark to Camel Message then the headers will be mapped as well (eg added as header to the Camel Message as well). You can turn off this option to disable this. The headers can still be accessed from the org.apache.camel.component.sparkrest.SparkMessage message with the method getRequest() that returns the Spark HTTP request instance.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_DEFAULT = true;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.source.endpoint.transferException";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_DOC = "If enabled and an Exchange failed processing on the consumer side, and if the caused Exception was send back serialized in the response as a application/x-java-serialized-object content type. This is by default turned off. If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_CONF = "camel.source.endpoint.urlDecodeHeaders";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_DOC = "If this option is enabled, then during binding from Spark to Camel Message then the header values will be URL decoded (eg %20 will be a space character.)";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_CONF = "camel.source.endpoint.matchOnUriPrefix";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_DOC = "Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_CONF = "camel.source.endpoint.sparkBinding";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_DOC = "To use a custom SparkBinding to map to/from Camel message.";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.spark-rest.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_CONF = "camel.component.spark-rest.ipAddress";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_DOC = "Set the IP address that Spark should listen on. If not called the default address is '0.0.0.0'.";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_DEFAULT = "0.0.0.0";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_CONF = "camel.component.spark-rest.port";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_DOC = "Port number. Will by default use 4567";
    public static final Integer CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_DEFAULT = 4567;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.spark-rest.basicPropertyBinding";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_CONF = "camel.component.spark-rest.maxThreads";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_DOC = "Maximum number of threads in Spark thread-pool (shared globally)";
    public static final Integer CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_CONF = "camel.component.spark-rest.minThreads";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_DOC = "Minimum number of threads in Spark thread-pool (shared globally)";
    public static final Integer CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_CONF = "camel.component.spark-rest.sparkBinding";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_DOC = "To use a custom SparkBinding to map to/from Camel message.";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_CONF = "camel.component.spark-rest.sparkConfiguration";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_DOC = "To use the shared SparkConfiguration";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_CONF = "camel.component.spark-rest.timeOutMillis";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_DOC = "Thread idle timeout in millis where threads that has been idle for a longer period will be terminated from the thread pool";
    public static final Integer CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_CONF = "camel.component.spark-rest.keystoreFile";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_DOC = "Configures connection to be secure to use the keystore file";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_CONF = "camel.component.spark-rest.keystorePassword";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_DOC = "Configures connection to be secure to use the keystore password";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_CONF = "camel.component.spark-rest.truststoreFile";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_DOC = "Configures connection to be secure to use the truststore file";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_CONF = "camel.component.spark-rest.truststorePassword";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_DOC = "Configures connection to be secure to use the truststore password";
    public static final String CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_DEFAULT = null;

    public CamelSparkrestSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSparkrestSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SPARKREST_PATH_VERB_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_PATH_VERB_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPARKREST_PATH_VERB_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_PATH_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_PATH_PATH_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPARKREST_PATH_PATH_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_ACCEPT_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_DISABLE_STREAM_CACHE_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_MAP_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_URL_DECODE_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_MATCH_ON_URI_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_SPARK_BINDING_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_IP_ADDRESS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_PORT_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_MAX_THREADS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_MIN_THREADS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_BINDING_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_SPARK_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_TIME_OUT_MILLIS_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_KEYSTORE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPARKREST_COMPONENT_TRUSTSTORE_PASSWORD_DOC);
        return conf;
    }
}