/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.nsq;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelNsqSourceConnectorConfig extends CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_NSQ_PATH_TOPIC_CONF = "camel.source.path.topic";
    public static final String CAMEL_SOURCE_NSQ_PATH_TOPIC_DOC = "The NSQ topic";
    public static final String CAMEL_SOURCE_NSQ_PATH_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_CONF = "camel.source.endpoint.servers";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_DOC = "The hostnames of one or more nsqlookupd servers (consumer) or nsqd servers (producer)";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_CONF = "camel.source.endpoint.userAgent";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_DOC = "A String to identify the kind of client";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_CONF = "camel.source.endpoint.autoFinish";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_DOC = "Automatically finish the NSQ Message when it is retrieved from the queue and before the Exchange is processed";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_DEFAULT = "true";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_CONF = "camel.source.endpoint.channel";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_DOC = "The NSQ channel";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_CONF = "camel.source.endpoint.lookupInterval";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_DOC = "The lookup interval";
    public static final Long CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_CONF = "camel.source.endpoint.lookupServerPort";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_DOC = "The NSQ lookup server port";
    public static final Integer CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_DEFAULT = 4161;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_CONF = "camel.source.endpoint.messageTimeout";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_DOC = "The NSQ consumer timeout period for messages retrieved from the queue. A value of -1 is the server default";
    public static final Long CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_DEFAULT = -1L;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_CONF = "camel.source.endpoint.poolSize";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_DOC = "Consumer pool size";
    public static final Integer CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_DEFAULT = 10;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_CONF = "camel.source.endpoint.requeueInterval";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_DOC = "The requeue interval in milliseconds. A value of -1 is the server default";
    public static final Long CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_DEFAULT = -1L;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_CONF = "camel.source.endpoint.secure";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_DOC = "Set secure option indicating TLS is required";
    public static final Boolean CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.source.endpoint.sslContextParameters";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_CONF = "camel.component.nsq.servers";
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_DOC = "The hostnames of one or more nsqlookupd servers (consumer) or nsqd servers (producer).";
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.nsq.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.nsq.basicPropertyBinding";
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.nsq.useGlobalSslContextParameters";
    public static final String CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelNsqSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelNsqSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_NSQ_PATH_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_PATH_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_NSQ_PATH_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_USER_AGENT_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_AUTO_FINISH_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_CHANNEL_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_LOOKUP_SERVER_PORT_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_MESSAGE_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_POOL_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_REQUEUE_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_SECURE_DOC);
        conf.define(CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_COMPONENT_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NSQ_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}