/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator.rules.mcf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Rule;
import org.jboss.jca.validator.Validate;

public class MCFHashCode
implements Rule {
    private static final String SECTION = "6.5.3.2";

    @Override
    public List<Failure> validate(Validate vo, ResourceBundle rb) {
        if (vo != null && Key.MANAGED_CONNECTION_FACTORY == vo.getKey() && vo.getClazz() != null && ManagedConnectionFactory.class.isAssignableFrom(vo.getClazz())) {
            boolean error = true;
            Class<?> clz = vo.getClazz();
            while (error && !clz.equals(Object.class)) {
                try {
                    Method hashCode = clz.getDeclaredMethod("hashCode", null);
                    if (hashCode == null) continue;
                    error = false;
                }
                catch (Throwable t) {
                    clz = clz.getSuperclass();
                }
            }
            if (error) {
                ArrayList<Failure> failures = new ArrayList<Failure>(1);
                Failure failure = new Failure(1, SECTION, rb.getString("mcf.MCFHashCode"), vo.getClazz().getName());
                failures.add(failure);
                return failures;
            }
        }
        return null;
    }
}

