/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.catalina.ThreadBindingListener;
import org.jboss.as.server.deployment.SetupAction;

public class ThreadSetupBindingListener
implements ThreadBindingListener {
    private final List<SetupAction> actions;

    public ThreadSetupBindingListener(List<SetupAction> setup) {
        this.actions = setup;
    }

    public void bind() {
        for (SetupAction action : this.actions) {
            action.setup(Collections.emptyMap());
        }
    }

    public void unbind() {
        ListIterator<SetupAction> iterator = this.actions.listIterator(this.actions.size());
        Throwable error = null;
        while (iterator.hasPrevious()) {
            SetupAction action = iterator.previous();
            try {
                action.teardown(Collections.emptyMap());
            }
            catch (Throwable e) {
                error = e;
            }
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
    }
}

