/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaASTAnnotationVisitor
extends ASTVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaASTAnnotationVisitor.class);
    private final Collection<AbstractDecoration> results;
    private final CompilationUnit cu;
    private final Map<String, String> classNameToFullyQualified = new HashMap<String, String>();

    public JavaASTAnnotationVisitor(CompilationUnit cu, Collection<AbstractDecoration> results, Set<String> knownDependencies) {
        this.results = results;
        this.cu = cu;
        for (String dependency : knownDependencies) {
            this.classNameToFullyQualified.put(StringUtils.substringAfterLast((String)dependency, (String)"."), dependency);
        }
    }

    public boolean visit(MarkerAnnotation node) {
        return super.visit(node);
    }

    protected String qualify(Name objects) {
        if (objects instanceof QualifiedName) {
            return this.qualify((QualifiedName)objects);
        }
        if (objects instanceof SimpleName) {
            return this.qualify((SimpleName)objects);
        }
        return objects.toString();
    }

    protected String qualify(QualifiedName name) {
        Name qualifier = name.getQualifier();
        String q = name.getQualifier().toString();
        if (qualifier instanceof QualifiedName) {
            q = this.qualify((QualifiedName)qualifier);
        } else if (qualifier instanceof SimpleName) {
            q = this.qualify((SimpleName)qualifier);
        }
        String n = this.qualify(name.getName());
        if (StringUtils.isNotBlank((String)q)) {
            n = q + "." + n;
        }
        return n;
    }

    protected String qualify(SimpleName name) {
        return this.qualify(name.toString());
    }

    protected String qualify(String className) {
        if (this.classNameToFullyQualified.containsKey(className)) {
            className = this.classNameToFullyQualified.get(className);
        }
        return className;
    }

    protected String extract(Expression value) {
        if (value instanceof Name) {
            return this.extract((Name)value);
        }
        if (value instanceof ArrayInitializer) {
            return this.extract((ArrayInitializer)value);
        }
        if (value instanceof NullLiteral) {
            return this.extract((NullLiteral)value);
        }
        if (value instanceof NumberLiteral) {
            return this.extract((NumberLiteral)value);
        }
        if (value instanceof StringLiteral) {
            return this.extract((StringLiteral)value);
        }
        if (value instanceof BooleanLiteral) {
            return this.extract((BooleanLiteral)value);
        }
        if (value instanceof TypeLiteral) {
            return this.extract((TypeLiteral)value);
        }
        return "Unknown: " + ReflectionToStringBuilder.toString((Object)value);
    }

    protected String extract(Name value) {
        return this.qualify(value);
    }

    protected String extract(ArrayInitializer value) {
        List objects = value.expressions();
        for (Object object : objects) {
            LOG.info("Array Object: " + this.extract((Expression)object));
        }
        return value.toString();
    }

    protected String extract(TypeLiteral value) {
        return this.qualify(value.toString());
    }

    protected String extract(NullLiteral value) {
        return value.toString();
    }

    protected String extract(NumberLiteral value) {
        return value.toString();
    }

    protected String extract(StringLiteral value) {
        String val = value.toString();
        val = StringUtils.removeStart((String)val, (String)"\"");
        val = StringUtils.removeEnd((String)val, (String)"\"");
        return val;
    }

    protected String extract(BooleanLiteral value) {
        return value.toString();
    }

    public boolean visit(NormalAnnotation node) {
        List objects = node.values();
        String name = this.qualify(node.getTypeName());
        LOG.info("Node Type: " + name);
        if (objects != null) {
            for (Object object : objects) {
                if (object instanceof MemberValuePair) {
                    MemberValuePair pair = (MemberValuePair)object;
                    String val = this.extract(pair.getValue());
                    LOG.info("Name: " + pair.getName().toString() + ", Value: " + val);
                    continue;
                }
                LOG.info("Unknown: Value: " + ReflectionToStringBuilder.toString(object));
            }
        }
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        Expression objects = node.getValue();
        String name = this.qualify(node.getTypeName());
        LOG.info("Node Type: " + name);
        if (objects != null) {
            this.extract(objects);
        }
        return super.visit(node);
    }

    public boolean visit(ImportDeclaration node) {
        String importVal = node.getName().toString();
        this.classNameToFullyQualified.put(StringUtils.substringAfterLast((String)importVal, (String)"."), importVal);
        return super.visit(node);
    }
}

