/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public interface SymbolProvider {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public List<SymbolInformation> get(SearchMatch var1) throws CoreException;

    default public SymbolKind convertSymbolKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                try {
                    IType type = (IType)element;
                    if (type.isInterface()) {
                        return SymbolKind.Interface;
                    }
                    if (type.isEnum()) {
                        return SymbolKind.Enum;
                    }
                }
                catch (JavaModelException type) {
                    // empty catch block
                }
                return SymbolKind.Class;
            }
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                IField field = (IField)element;
                try {
                    if (field.isEnumConstant()) {
                        return SymbolKind.EnumMember;
                    }
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                        return SymbolKind.Constant;
                    }
                }
                catch (JavaModelException flags) {
                    // empty catch block
                }
                return SymbolKind.Field;
            }
            case 12: 
            case 13: 
            case 17: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: {
                return SymbolKind.Variable;
            }
            case 15: {
                return SymbolKind.TypeParameter;
            }
            case 9: {
                try {
                    if (element instanceof IMethod && ((IMethod)element).isConstructor()) {
                        return SymbolKind.Constructor;
                    }
                    return SymbolKind.Method;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Method;
                }
            }
            case 11: {
                return SymbolKind.Package;
            }
        }
        return SymbolKind.String;
    }

    default public Location getLocation(IJavaElement element, SearchMatch match) throws JavaModelException {
        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
        if (compilationUnit != null) {
            JavaLanguageServerPlugin.logInfo((String)("found compliation unit for match: " + String.valueOf(match)));
            return JDTUtils.toLocation((ICompilationUnit)compilationUnit, (int)match.getOffset(), (int)match.getLength());
        }
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (cf != null) {
            String packageName = cf.getParent().getElementName();
            String uriString = null;
            try {
                String query = "packageName=" + packageName + "." + cf.getElementName();
                query = SourceRange.isAvailable((ISourceRange)cf.getSourceRange()) ? query + "&source-range=true" : query + "&source-range=false";
                uriString = new URI("konveyor-jdt", "contents", cf.getPath().toString(), query, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException((String)"Error generating URI for class ", (Throwable)e);
                return null;
            }
            if (uriString == null) {
                JavaLanguageServerPlugin.logInfo((String)("Unable to determine location for the element " + String.valueOf(element)));
                return null;
            }
            Range range = null;
            try {
                range = this.toRange((IOpenable)cf, match.getOffset(), match.getLength());
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException((String)"Error generating range for class ", (Throwable)e);
                return null;
            }
            JavaLanguageServerPlugin.logInfo((String)("Found CF info: " + uriString + " range: " + String.valueOf(range)));
            return new Location(uriString, range);
        }
        try {
            JavaLanguageServerPlugin.logInfo((String)("defaulting to regular toLocation for match: " + String.valueOf(match)));
            return JDTUtils.toLocation((IJavaElement)element);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)("Unable to determine location for the element " + String.valueOf(element)), (Throwable)e);
            return null;
        }
    }

    private Range toRange(IOpenable openable, int offset, int length) throws Exception {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            IBuffer buffer = openable.getBuffer();
            if (buffer != null) {
                loc = JsonRpcHelpers.toLine((IBuffer)buffer, (int)offset);
                endLoc = JsonRpcHelpers.toLine((IBuffer)buffer, (int)(offset + length));
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            SymbolProvider.setPosition(range.getStart(), loc);
            SymbolProvider.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    private static void setPosition(Position position, int[] coords) {
        assert (coords.length == 2);
        position.setLine(coords[0]);
        position.setCharacter(coords[1]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public boolean queryQualificationMatches(String query, ICompilationUnit unit, Location location) {
        query = query.replaceAll("(?<!\\.)\\*", ".*");
        String queryQualification = "";
        int dotIndex = query.lastIndexOf(46);
        if (dotIndex > 0) {
            queryQualification = query.substring(0, dotIndex);
        }
        String packageQueryQualification = "";
        int packageDotIndex = queryQualification.lastIndexOf(46);
        if (packageDotIndex > 0) {
            packageQueryQualification = queryQualification.substring(0, packageDotIndex);
        }
        if (queryQualification != "" && location.getUri().contains(queryQualification.replaceAll(".", "/"))) {
            return true;
        }
        if (unit == null) return false;
        try {
            IPackageDeclaration[] iPackageDeclarationArray = unit.getPackageDeclarations();
            int n = iPackageDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageDeclaration packageDecl = iPackageDeclarationArray[n2];
                if (packageQueryQualification != "" && packageDecl.getElementName().matches(packageQueryQualification)) {
                    return true;
                }
                ++n2;
            }
            iPackageDeclarationArray = unit.getImports();
            n = iPackageDeclarationArray.length;
            n2 = 0;
            while (n2 < n) {
                IPackageDeclaration importDecl = iPackageDeclarationArray[n2];
                String importElement = importDecl.getElementName();
                String importQualification = "";
                int importDotIndex = query.lastIndexOf(46);
                if (importDotIndex > 0) {
                    importQualification = query.substring(0, dotIndex);
                }
                if (query.matches(importElement)) {
                    return true;
                }
                if (importElement.matches(query)) {
                    return true;
                }
                if (importElement.contains("*") && queryQualification != "") {
                    if (queryQualification.startsWith(importQualification)) {
                        return true;
                    }
                    if (importElement.replaceAll(".*", "").matches(queryQualification)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)"unable to determine accuracy of the match");
        }
        return false;
    }
}

