/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal;

import io.konveyor.tackle.core.internal.query.AnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.SymbolProviderResolver;
import io.konveyor.tackle.core.internal.symbol.WithAnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.WithMaxResults;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.lsp4j.SymbolInformation;

public class SymbolInformationTypeRequestor
extends SearchRequestor {
    private List<SymbolInformation> symbols;
    private int maxResults;
    private int numberSearchMatches;
    private boolean sourceOnly;
    private boolean isSymbolTagSupported;
    private IProgressMonitor monitor;
    private int symbolKind;
    private String query;
    private AnnotationQuery annotationQuery;
    private SymbolProviderResolver resolver;

    public SymbolInformationTypeRequestor(List<SymbolInformation> symbols, int maxResults, IProgressMonitor monitor, int symbolKind, String query, AnnotationQuery annotationQuery) {
        this.symbols = symbols;
        this.maxResults = maxResults;
        this.monitor = monitor;
        this.symbolKind = symbolKind;
        this.query = query;
        this.numberSearchMatches = 0;
        this.annotationQuery = annotationQuery;
        if (maxResults == 0) {
            this.maxResults = 10000;
        }
        this.resolver = new SymbolProviderResolver();
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        ++this.numberSearchMatches;
        if (this.maxResults > 0 && this.symbols.size() >= this.maxResults) {
            this.monitor.setCanceled(true);
            JavaLanguageServerPlugin.logInfo((String)"maxResults > 0 && symbols.size() >= maxResults");
            return;
        }
        if (match.isInsideDocComment()) {
            JavaLanguageServerPlugin.logInfo((String)("found match inside doc comment: " + String.valueOf(match)));
            return;
        }
        if ((match.getResource().getType() | 1) == 0 || match.getElement() == null) {
            JavaLanguageServerPlugin.logInfo((String)"match.getResource().getType() | IResource.FILE");
            return;
        }
        SymbolProvider symbolProvider = this.resolver.resolve(this.symbolKind);
        if (symbolProvider instanceof WithQuery) {
            ((WithQuery)((Object)symbolProvider)).setQuery(this.query);
        }
        if (symbolProvider instanceof WithAnnotationQuery) {
            ((WithAnnotationQuery)((Object)symbolProvider)).setAnnotationQuery(this.annotationQuery);
        }
        if (symbolProvider instanceof WithMaxResults) {
            ((WithMaxResults)((Object)symbolProvider)).setMaxResultes(this.maxResults);
        }
        JavaLanguageServerPlugin.logInfo((String)("getting match: " + String.valueOf(match) + "with provider: " + String.valueOf(symbolProvider)));
        List symbols = Optional.ofNullable(symbolProvider.get(match)).orElse(new ArrayList());
        this.symbols.addAll(symbols);
    }

    public List<SymbolInformation> getSymbols() {
        return this.symbols;
    }

    public int getAllSearchMatches() {
        return this.numberSearchMatches;
    }

    private boolean shouldCheckAccuracy(IJavaElement element) throws CoreException {
        List errors = ResourceUtils.getErrorMarkers((IResource)element.getPrimaryElement().getResource());
        if (errors != null && !errors.isEmpty()) {
            JavaLanguageServerPlugin.logInfo((String)("unable to check accuracy for element: " + String.valueOf(element) + " got errors: " + String.valueOf(errors)));
            return false;
        }
        return true;
    }
}

