/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.symbol.ConstructorCallSymbolProvider;
import io.konveyor.tackle.core.internal.symbol.ImportSymbolProvider;
import io.konveyor.tackle.core.internal.symbol.MethodCallSymbolProvider;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.TypeSymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithMaxResults;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.SymbolInformation;

public class DefaultSymbolProvider
implements SymbolProvider,
WithQuery,
WithMaxResults {
    private List<SymbolProvider> defaultProviders = new ArrayList<SymbolProvider>();
    private int maxResults;
    private String query;

    public DefaultSymbolProvider() {
        this.defaultProviders.add(new MethodCallSymbolProvider());
        this.defaultProviders.add(new ConstructorCallSymbolProvider());
        this.defaultProviders.add(new ImportSymbolProvider());
        this.defaultProviders.add(new TypeSymbolProvider());
    }

    @Override
    public List<SymbolInformation> get(SearchMatch match) throws CoreException {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        for (SymbolProvider p : this.defaultProviders) {
            if (p instanceof WithQuery) {
                ((WithQuery)((Object)p)).setQuery(this.query);
            }
            if (p instanceof WithMaxResults) {
                ((WithMaxResults)((Object)p)).setMaxResultes(this.maxResults);
            }
            JavaLanguageServerPlugin.logInfo((String)("default provider: " + String.valueOf(p)));
            List<SymbolInformation> specificSymbols = p.get(match);
            if (specificSymbols == null || specificSymbols.isEmpty()) continue;
            symbols.addAll(specificSymbols);
            JavaLanguageServerPlugin.logInfo((String)("got Symbols: " + symbols.size()));
            if (this.maxResults == 0 || symbols.size() < this.maxResults) continue;
            return symbols;
        }
        return symbols;
    }

    @Override
    public void setMaxResultes(int maxResults) {
        this.maxResults = 100;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }
}

