/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.distribution;

import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public final class CountAtBucket {
    private final long bucket;
    private final double count;

    public CountAtBucket(long bucket, double count) {
        this.bucket = bucket;
        this.count = count;
    }

    public long bucket() {
        return this.bucket;
    }

    public double bucket(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.bucket, unit);
    }

    public double count() {
        return this.count;
    }

    public String toString() {
        return "(" + this.count + " at " + this.bucket + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountAtBucket that = (CountAtBucket)o;
        return this.bucket == that.bucket && Double.compare(that.count, this.count) == 0;
    }

    public int hashCode() {
        int result = (int)(this.bucket ^ this.bucket >>> 32);
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

