/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractAggregatingMessageGroupProcessor
implements MessageGroupProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    @Override
    public final Object processMessageGroup(MessageGroup group) {
        Assert.notNull((Object)group, (String)"MessageGroup must not be null");
        Map<String, Object> headers = this.aggregateHeaders(group);
        Object payload = this.aggregatePayloads(group, headers);
        AbstractIntegrationMessageBuilder<Object> builder = payload instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)payload) : (payload instanceof AbstractIntegrationMessageBuilder ? (AbstractIntegrationMessageBuilder<Object>)payload : this.getMessageBuilderFactory().withPayload(payload));
        return builder.copyHeadersIfAbsent(headers);
    }

    protected Map<String, Object> aggregateHeaders(MessageGroup group) {
        HashMap<String, Object> aggregatedHeaders = new HashMap<String, Object>();
        HashSet<String> conflictKeys = new HashSet<String>();
        for (Message<?> message : group.getMessages()) {
            for (Map.Entry entry : message.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                if ("id".equals(key) || "timestamp".equals(key) || "sequenceSize".equals(key) || "sequenceNumber".equals(key)) continue;
                Object value = entry.getValue();
                if (!aggregatedHeaders.containsKey(key)) {
                    aggregatedHeaders.put(key, value);
                    continue;
                }
                Object existingValue = aggregatedHeaders.get(key);
                if (value == existingValue || value != null && value.equals(existingValue)) continue;
                conflictKeys.add(key);
            }
        }
        for (String keyToRemove : conflictKeys) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding header '" + keyToRemove + "' upon aggregation due to conflict(s) in MessageGroup with correlation key: " + group.getGroupId()));
            }
            aggregatedHeaders.remove(keyToRemove);
        }
        return aggregatedHeaders;
    }

    protected abstract Object aggregatePayloads(MessageGroup var1, Map<String, Object> var2);
}

