/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.ArrayDeque;
import java.util.List;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.integration.support.management.metrics.CounterFacade;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;

public abstract class AbstractPollableChannel
extends AbstractMessageChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private volatile int executorInterceptorsSize;
    private CounterFacade receiveCounter;

    @Override
    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    @Override
    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    @Override
    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    @Override
    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    @Nullable
    public Message<?> receive() {
        return this.receive(-1L);
    }

    @Nullable
    public Message<?> receive(long timeout) {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque<ChannelInterceptor> interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + this + "'"));
            }
            if (interceptorList.getSize() > 0 && !interceptorList.preReceive(this, interceptorStack = new ArrayDeque<ChannelInterceptor>())) {
                return null;
            }
            Message<?> message = this.doReceive(timeout);
            if (message == null) {
                if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + this + "', message is null"));
                }
            } else {
                if (countsEnabled) {
                    if (this.getMetricsCaptor() != null) {
                        this.incrementReceiveCounter();
                    }
                    this.getMetrics().afterReceive();
                    counted = true;
                }
                if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("postReceive on channel '" + this + "', message: " + message));
                }
            }
            if (interceptorStack != null) {
                if (message != null) {
                    message = interceptorList.postReceive(message, this);
                }
                interceptorList.afterReceiveCompletion(message, this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                if (this.getMetricsCaptor() != null) {
                    CounterFacade counter = this.getMetricsCaptor().counterBuilder("spring.integration.receive").tag("name", this.getComponentName() == null ? "unknown" : this.getComponentName()).tag("type", "channel").tag("result", "failure").tag("exception", e.getClass().getSimpleName()).description("Messages received").build();
                    this.meters.add(counter);
                    counter.increment();
                }
                this.getMetrics().afterError();
            }
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, this, e, interceptorStack);
            }
            throw e;
        }
    }

    private void incrementReceiveCounter() {
        if (this.receiveCounter == null) {
            this.receiveCounter = this.getMetricsCaptor().counterBuilder("spring.integration.receive").tag("name", this.getComponentName()).tag("type", "channel").tag("result", "success").tag("exception", "none").description("Messages received").build();
        }
        this.receiveCounter.increment();
    }

    @Override
    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    @Override
    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    @Override
    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }

    @Nullable
    protected abstract Message<?> doReceive(long var1);

    @Override
    public void destroy() throws Exception {
        super.destroy();
        if (this.receiveCounter != null) {
            this.receiveCounter.remove();
        }
    }
}

