/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.endpoint.ReactiveStreamsConsumer;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.advice.HandleMessageAdvice;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConsumerEndpointFactoryBean
implements FactoryBean<AbstractEndpoint>,
BeanFactoryAware,
BeanNameAware,
BeanClassLoaderAware,
InitializingBean,
SmartLifecycle,
DisposableBean {
    private static final Log logger = LogFactory.getLog(ConsumerEndpointFactoryBean.class);
    private final Object initializationMonitor = new Object();
    private final Object handlerMonitor = new Object();
    private MessageHandler handler;
    private String beanName;
    private String inputChannelName;
    private PollerMetadata pollerMetadata;
    private Boolean autoStartup;
    private int phase = 0;
    private boolean isPhaseSet;
    private String role;
    private MessageChannel inputChannel;
    private ConfigurableBeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private List<Advice> adviceChain;
    private DestinationResolver<MessageChannel> channelResolver;
    private TaskScheduler taskScheduler;
    private volatile AbstractEndpoint endpoint;
    private volatile boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandler(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        Object object = this.handlerMonitor;
        synchronized (object) {
            Assert.isNull((Object)this.handler, (String)"handler cannot be overridden");
            this.handler = handler;
        }
    }

    public void setInputChannel(MessageChannel inputChannel) {
        this.inputChannel = inputChannel;
    }

    public void setInputChannelName(String inputChannelName) {
        this.inputChannelName = inputChannelName;
    }

    public void setPollerMetadata(PollerMetadata pollerMetadata) {
        this.pollerMetadata = pollerMetadata;
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
        this.isPhaseSet = true;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)beanFactory, (String)"a ConfigurableBeanFactory is required");
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        Assert.notNull(adviceChain, (String)"adviceChain must not be null");
        this.adviceChain = adviceChain;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void afterPropertiesSet() throws Exception {
        block11: {
            if (this.beanName == null) {
                logger.error((Object)("The MessageHandler [" + this.handler + "] will be created without a 'componentName'. Consider specifying the 'beanName' property on this ConsumerEndpointFactoryBean."));
            } else {
                try {
                    if (!this.beanName.startsWith("org.springframework")) {
                        Object target;
                        MessageHandler targetHandler = this.handler;
                        if (AopUtils.isAopProxy((Object)targetHandler) && (target = ((Advised)targetHandler).getTargetSource().getTarget()) instanceof MessageHandler) {
                            targetHandler = (MessageHandler)target;
                        }
                        if (targetHandler instanceof IntegrationObjectSupport) {
                            ((IntegrationObjectSupport)targetHandler).setComponentName(this.beanName);
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("Could not set component name for handler " + this.handler + " for " + this.beanName + " :" + e.getMessage()));
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            Class targetClass = AopUtils.getTargetClass((Object)this.handler);
            boolean replyMessageHandler = AbstractReplyProducingMessageHandler.class.isAssignableFrom(targetClass);
            for (Advice advice : this.adviceChain) {
                if (replyMessageHandler && !(advice instanceof HandleMessageAdvice)) continue;
                NameMatchMethodPointcutAdvisor handlerAdvice = new NameMatchMethodPointcutAdvisor(advice);
                handlerAdvice.addMethodName("handleMessage");
                if (this.handler instanceof Advised) {
                    ((Advised)this.handler).addAdvisor((Advisor)handlerAdvice);
                    continue;
                }
                ProxyFactory proxyFactory = new ProxyFactory((Object)this.handler);
                proxyFactory.addAdvisor((Advisor)handlerAdvice);
                this.handler = (MessageHandler)proxyFactory.getProxy(this.beanClassLoader);
            }
        }
        if (this.channelResolver == null) {
            this.channelResolver = new BeanFactoryMessageChannelDestinationResolver((BeanFactory)this.beanFactory);
        }
        this.initializeEndpoint();
    }

    public AbstractEndpoint getObject() throws Exception {
        if (!this.initialized) {
            this.initializeEndpoint();
        }
        return this.endpoint;
    }

    public Class<?> getObjectType() {
        if (this.endpoint == null) {
            return AbstractEndpoint.class;
        }
        return this.endpoint.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEndpoint() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            MessageChannel channel = null;
            if (StringUtils.hasText((String)this.inputChannelName)) {
                channel = (MessageChannel)this.channelResolver.resolveDestination(this.inputChannelName);
            }
            if (this.inputChannel != null) {
                channel = this.inputChannel;
            }
            Assert.state((channel != null ? 1 : 0) != 0, (String)"one of inputChannelName or inputChannel is required");
            if (channel instanceof SubscribableChannel) {
                Assert.isNull((Object)this.pollerMetadata, (String)("A poller should not be specified for endpoint '" + this.beanName + "', since '" + channel + "' is a SubscribableChannel (not pollable)."));
                this.endpoint = new EventDrivenConsumer((SubscribableChannel)channel, this.handler);
                if (logger.isWarnEnabled() && Boolean.FALSE.equals(this.autoStartup) && channel instanceof FixedSubscriberChannel) {
                    logger.warn((Object)"'autoStartup=\"false\"' has no effect when using a FixedSubscriberChannel");
                }
            } else if (channel instanceof PollableChannel) {
                PollingConsumer pollingConsumer = new PollingConsumer((PollableChannel)channel, this.handler);
                if (this.pollerMetadata == null) {
                    this.pollerMetadata = PollerMetadata.getDefaultPollerMetadata((BeanFactory)this.beanFactory);
                    Assert.notNull((Object)this.pollerMetadata, (String)("No poller has been defined for endpoint '" + this.beanName + "', and no default poller is available within the context."));
                }
                pollingConsumer.setTaskExecutor(this.pollerMetadata.getTaskExecutor());
                pollingConsumer.setTrigger(this.pollerMetadata.getTrigger());
                pollingConsumer.setAdviceChain(this.pollerMetadata.getAdviceChain());
                pollingConsumer.setMaxMessagesPerPoll(this.pollerMetadata.getMaxMessagesPerPoll());
                pollingConsumer.setErrorHandler(this.pollerMetadata.getErrorHandler());
                pollingConsumer.setReceiveTimeout(this.pollerMetadata.getReceiveTimeout());
                pollingConsumer.setTransactionSynchronizationFactory(this.pollerMetadata.getTransactionSynchronizationFactory());
                pollingConsumer.setBeanClassLoader(this.beanClassLoader);
                pollingConsumer.setBeanFactory((BeanFactory)this.beanFactory);
                this.endpoint = pollingConsumer;
            } else {
                this.endpoint = new ReactiveStreamsConsumer(channel, this.handler);
            }
            this.endpoint.setBeanName(this.beanName);
            this.endpoint.setBeanFactory((BeanFactory)this.beanFactory);
            if (this.autoStartup != null) {
                this.endpoint.setAutoStartup(this.autoStartup);
            }
            int phaseToSet = this.phase;
            if (!this.isPhaseSet) {
                phaseToSet = this.endpoint instanceof PollingConsumer ? 0x3FFFFFFF : Integer.MIN_VALUE;
            }
            this.endpoint.setPhase(phaseToSet);
            this.endpoint.setRole(this.role);
            if (this.taskScheduler != null) {
                this.endpoint.setTaskScheduler(this.taskScheduler);
            }
            this.endpoint.afterPropertiesSet();
            this.initialized = true;
        }
    }

    public boolean isAutoStartup() {
        return this.endpoint == null || this.endpoint.isAutoStartup();
    }

    public int getPhase() {
        return this.endpoint != null ? this.endpoint.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.endpoint != null && this.endpoint.isRunning();
    }

    public void start() {
        if (this.endpoint != null) {
            this.endpoint.start();
        }
    }

    public void stop() {
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.endpoint != null) {
            this.endpoint.stop(callback);
        } else {
            callback.run();
        }
    }

    public void destroy() throws Exception {
        if (this.endpoint != null) {
            this.endpoint.destroy();
        }
    }
}

