/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.MethodInvokingMessageSource;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class InboundChannelAdapterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<InboundChannelAdapter> {
    private static final Class<?> kotlinFunction0Class;

    public InboundChannelAdapterAnnotationPostProcessor(ConfigurableListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    protected String getInputChannelAttribute() {
        return "value";
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, List<Annotation> annotations) {
        String channelName = MessagingAnnotationUtils.resolveAttribute(annotations, "value", String.class);
        Assert.hasText((String)channelName, (String)"The channel ('value' attribute of @InboundChannelAdapter) can't be empty.");
        MessageSource<?> messageSource = null;
        try {
            messageSource = this.createMessageSource(bean, beanName, method);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping endpoint creation; " + e.getMessage() + "; perhaps due to some '@Conditional' annotation."));
            }
            return null;
        }
        SourcePollingChannelAdapter adapter = new SourcePollingChannelAdapter();
        adapter.setOutputChannelName(channelName);
        adapter.setSource(messageSource);
        this.configurePollingEndpoint(adapter, annotations);
        return adapter;
    }

    private MessageSource<?> createMessageSource(Object beanArg, String beanName, Method methodArg) {
        MessageSource messageSource = null;
        Object bean = beanArg;
        Method method = methodArg;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            Class<?> targetClass = target.getClass();
            Assert.isTrue((MessageSource.class.isAssignableFrom(targetClass) || Supplier.class.isAssignableFrom(targetClass) || kotlinFunction0Class == null || kotlinFunction0Class.isAssignableFrom(targetClass) ? 1 : 0) != 0, (String)("The '" + this.annotationType + "' on @Bean method level is allowed only for: " + MessageSource.class.getName() + " or " + Supplier.class.getName() + (kotlinFunction0Class != null ? " or " + kotlinFunction0Class.getName() : "") + " beans"));
            if (target instanceof MessageSource) {
                messageSource = (MessageSource)target;
            } else if (target instanceof Supplier) {
                method = ReflectionUtils.findMethod(Supplier.class, (String)"get");
                bean = target;
            } else if (kotlinFunction0Class != null) {
                method = ReflectionUtils.findMethod(kotlinFunction0Class, (String)"invoke");
                bean = target;
            }
        }
        if (messageSource == null) {
            MethodInvokingMessageSource methodInvokingMessageSource = new MethodInvokingMessageSource();
            methodInvokingMessageSource.setObject(bean);
            methodInvokingMessageSource.setMethod(method);
            String messageSourceBeanName = this.generateHandlerBeanName(beanName, method);
            this.beanFactory.registerSingleton(messageSourceBeanName, (Object)methodInvokingMessageSource);
            messageSource = (MessageSource)this.beanFactory.initializeBean((Object)methodInvokingMessageSource, messageSourceBeanName);
            if (this.disposables != null) {
                this.disposables.add(methodInvokingMessageSource);
            }
        }
        return messageSource;
    }

    @Override
    protected String generateHandlerBeanName(String originalBeanName, Method method) {
        return super.generateHandlerBeanName(originalBeanName, method).replaceFirst(".handler$", ".source");
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }

    static {
        Class kotlinClass = null;
        try {
            kotlinClass = ClassUtils.forName((String)"kotlin.jvm.functions.Function0", (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            kotlinFunction0Class = kotlinClass;
        }
    }
}

