/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.SpringVersion;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ApplicationEventMulticasterParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        return "org.springframework.context.event.SimpleApplicationEventMulticaster";
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "applicationEventMulticaster";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String taskExecutorRef = element.getAttribute("task-executor");
        if (StringUtils.hasText((String)taskExecutorRef)) {
            builder.addPropertyReference("taskExecutor", taskExecutorRef);
        } else {
            BeanDefinitionBuilder executorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor");
            executorBuilder.addPropertyValue("corePoolSize", (Object)1);
            executorBuilder.addPropertyValue("maxPoolSize", (Object)10);
            executorBuilder.addPropertyValue("queueCapacity", (Object)0);
            executorBuilder.addPropertyValue("threadNamePrefix", (Object)"event-multicaster-");
            String executorBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)executorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            builder.addPropertyReference("taskExecutor", executorBeanName);
        }
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null && springVersion.startsWith("2")) {
            builder.addPropertyValue("collectionClass", CopyOnWriteArraySet.class);
        }
    }
}

