/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.messaging.MessageChannel;

public class StandardIntegrationFlow
implements IntegrationFlow,
SmartLifecycle {
    private final Map<Object, String> integrationComponents;
    private final List<SmartLifecycle> lifecycles = new LinkedList<SmartLifecycle>();
    private MessageChannel inputChannel;
    private boolean running;

    StandardIntegrationFlow(Map<Object, String> integrationComponents) {
        this.integrationComponents = new LinkedHashMap<Object, String>(integrationComponents);
    }

    @Override
    public void configure(IntegrationFlowDefinition<?> flow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageChannel getInputChannel() {
        if (this.inputChannel == null) {
            this.inputChannel = this.integrationComponents.keySet().stream().filter(MessageChannel.class::isInstance).map(MessageChannel.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("The 'IntegrationFlow' [" + this + "] doesn't start with 'MessageChannel' for direct message sending."));
        }
        return this.inputChannel;
    }

    public void setIntegrationComponents(Map<Object, String> integrationComponents) {
        this.integrationComponents.clear();
        this.integrationComponents.putAll(integrationComponents);
    }

    public Map<Object, String> getIntegrationComponents() {
        return Collections.unmodifiableMap(this.integrationComponents);
    }

    public void start() {
        if (!this.running) {
            LinkedList<Object> components = new LinkedList<Object>(this.integrationComponents.keySet());
            ListIterator iterator = components.listIterator(this.integrationComponents.size());
            this.lifecycles.clear();
            while (iterator.hasPrevious()) {
                Object component = iterator.previous();
                if (!(component instanceof SmartLifecycle)) continue;
                this.lifecycles.add((SmartLifecycle)component);
                ((SmartLifecycle)component).start();
            }
            this.running = true;
        }
    }

    public void stop(Runnable callback) {
        if (this.lifecycles.size() > 0) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(this.lifecycles.size(), callback);
            ListIterator<SmartLifecycle> iterator = this.lifecycles.listIterator(this.lifecycles.size());
            while (iterator.hasPrevious()) {
                SmartLifecycle lifecycle = iterator.previous();
                if (lifecycle.isRunning()) {
                    lifecycle.stop((Runnable)aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
        this.running = false;
    }

    public void stop() {
        ListIterator<SmartLifecycle> iterator = this.lifecycles.listIterator(this.lifecycles.size());
        while (iterator.hasPrevious()) {
            iterator.previous().stop();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public int getPhase() {
        return 0;
    }

    public String toString() {
        return "StandardIntegrationFlow{integrationComponents=" + this.integrationComponents + '}';
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() <= 0) {
                this.finishCallback.run();
            }
        }
    }
}

