/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class MessageProducerSupport
extends AbstractEndpoint
implements MessageProducer,
TrackableComponent,
SmartInitializingSingleton {
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private volatile MessageChannel outputChannel;
    private volatile String outputChannelName;
    private volatile MessageChannel errorChannel;
    private volatile String errorChannelName;
    private volatile boolean shouldTrack = false;

    protected MessageProducerSupport() {
        this.setPhase(0x3FFFFFFF);
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    @Override
    public void setOutputChannelName(String outputChannelName) {
        Assert.hasText((String)outputChannelName, (String)"'outputChannelName' must not be null or empty");
        this.outputChannelName = outputChannelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel getOutputChannel() {
        if (this.outputChannelName != null) {
            MessageProducerSupport messageProducerSupport = this;
            synchronized (messageProducerSupport) {
                if (this.outputChannelName != null) {
                    this.outputChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.outputChannelName);
                    this.outputChannelName = null;
                }
            }
        }
        return this.outputChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannelName) {
        Assert.hasText((String)errorChannelName, (String)"'errorChannelName' must not be empty");
        this.errorChannelName = errorChannelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel getErrorChannel() {
        if (this.errorChannelName != null) {
            MessageProducerSupport messageProducerSupport = this;
            synchronized (messageProducerSupport) {
                if (this.errorChannelName != null) {
                    this.errorChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.errorChannelName);
                    this.errorChannelName = null;
                }
            }
        }
        return this.errorChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    public final void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        Assert.notNull((Object)errorMessageStrategy, (String)"'errorMessageStrategy' cannot be null");
        this.errorMessageStrategy = errorMessageStrategy;
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void afterSingletonsInstantiated() {
        Assert.state((this.outputChannel != null || StringUtils.hasText((String)this.outputChannelName) ? 1 : 0) != 0, (String)"'outputChannel' or 'outputChannelName' is required");
    }

    @Override
    protected void onInit() {
        try {
            super.onInit();
        }
        catch (Exception e) {
            throw new BeanInitializationException("Cannot initialize: " + this, (Throwable)e);
        }
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    protected void sendMessage(Message<?> messageArg) {
        block4: {
            Message<?> message = messageArg;
            if (message == null) {
                throw new MessagingException("cannot send a null message");
            }
            if (this.shouldTrack) {
                message = MessageHistory.write(message, this, this.getMessageBuilderFactory());
            }
            try {
                this.messagingTemplate.send(this.getOutputChannel(), message);
            }
            catch (RuntimeException e) {
                if (this.sendErrorMessageIfNecessary(message, e)) break block4;
                throw e;
            }
        }
    }

    protected final boolean sendErrorMessageIfNecessary(Message<?> message, RuntimeException exception) {
        MessageChannel channel = this.getErrorChannel();
        if (channel != null) {
            this.messagingTemplate.send(channel, (Message)this.buildErrorMessage(message, exception));
            return true;
        }
        return false;
    }

    protected final ErrorMessage buildErrorMessage(Message<?> message, RuntimeException exception) {
        return this.errorMessageStrategy.buildErrorMessage(exception, this.getErrorMessageAttributes(message));
    }

    protected AttributeAccessor getErrorMessageAttributes(Message<?> message) {
        return ErrorMessageUtils.getAttributeAccessor(message, null);
    }
}

