/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import com.fasterxml.jackson.core.TreeNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.integration.channel.ReactiveStreamsSubscribableChannel;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.integration.util.FunctionIterator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

public abstract class AbstractMessageSplitter
extends AbstractReplyProducingMessageHandler {
    private boolean applySequence = true;

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    protected final Object handleRequestMessage(Message<?> message) {
        int sequenceSize;
        Object result = this.splitMessage(message);
        if (result == null) {
            return null;
        }
        boolean reactive = this.getOutputChannel() instanceof ReactiveStreamsSubscribableChannel;
        this.setAsync(reactive);
        Iterator<Object> iterator = null;
        Flux flux = null;
        if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            sequenceSize = this.obtainSizeIfPossible(iterable);
            if (reactive) {
                flux = Flux.fromIterable((Iterable)iterable);
            } else {
                iterator = iterable.iterator();
            }
        } else if (result.getClass().isArray()) {
            Object[] items = ObjectUtils.toObjectArray((Object)result);
            sequenceSize = items.length;
            if (reactive) {
                flux = Flux.fromArray((Object[])items);
            } else {
                iterator = Arrays.asList(items).iterator();
            }
        } else if (result instanceof Iterator) {
            Iterator iter = (Iterator)result;
            sequenceSize = this.obtainSizeIfPossible(iter);
            if (reactive) {
                flux = Flux.fromIterable(() -> iter);
            } else {
                iterator = iter;
            }
        } else if (result instanceof Stream) {
            Stream stream = (Stream)result;
            sequenceSize = 0;
            if (reactive) {
                flux = Flux.fromStream((Stream)stream);
            } else {
                iterator = stream.iterator();
            }
        } else if (result instanceof Publisher) {
            Publisher publisher = (Publisher)result;
            sequenceSize = 0;
            if (reactive) {
                flux = Flux.from((Publisher)publisher);
            } else {
                iterator = Flux.from((Publisher)((Publisher)result)).toIterable().iterator();
            }
        } else {
            sequenceSize = 1;
            if (reactive) {
                flux = Flux.just((Object)result);
            } else {
                iterator = Collections.singleton(result).iterator();
            }
        }
        if (iterator != null && !iterator.hasNext()) {
            return null;
        }
        Object messageHeaders = message.getHeaders();
        if (this.willAddHeaders(message)) {
            messageHeaders = new HashMap(messageHeaders);
            this.addHeaders(message, (Map<String, Object>)messageHeaders);
        }
        MessageHeaders headers = messageHeaders;
        UUID correlationId = message.getHeaders().getId();
        AtomicInteger sequenceNumber = new AtomicInteger(1);
        Function<Object, AbstractIntegrationMessageBuilder> messageBuilderFunction = arg_0 -> this.lambda$handleRequestMessage$1((Map)headers, correlationId, sequenceNumber, sequenceSize, arg_0);
        if (reactive) {
            return flux.map(messageBuilderFunction);
        }
        return new FunctionIterator<Object, AbstractIntegrationMessageBuilder>(result instanceof AutoCloseable && !result.equals(iterator) ? (AutoCloseable)result : null, iterator, messageBuilderFunction);
    }

    protected int obtainSizeIfPossible(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (JacksonPresent.isJackson2Present() && JacksonNodeHelper.isNode(iterable)) {
            return JacksonNodeHelper.nodeSize(iterable);
        }
        return 0;
    }

    protected int obtainSizeIfPossible(Iterator<?> iterator) {
        return 0;
    }

    private AbstractIntegrationMessageBuilder<?> createBuilder(Object item, Map<String, Object> headers, Object correlationId, int sequenceNumber, int sequenceSize) {
        AbstractIntegrationMessageBuilder<Object> builder = item instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)item) : (item instanceof AbstractIntegrationMessageBuilder ? (AbstractIntegrationMessageBuilder<Object>)item : this.getMessageBuilderFactory().withPayload(item));
        builder.copyHeadersIfAbsent(headers);
        if (this.applySequence) {
            builder.pushSequenceDetails(correlationId, sequenceNumber, sequenceSize);
        }
        return builder;
    }

    protected boolean willAddHeaders(Message<?> message) {
        return false;
    }

    protected void addHeaders(Message<?> message, Map<String, Object> headers) {
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void produceOutput(Object result, Message<?> requestMessage) {
        if (result instanceof Iterator) {
            Iterator iterator = (Iterator)result;
            try {
                while (iterator.hasNext()) {
                    super.produceOutput(iterator.next(), requestMessage);
                }
            }
            finally {
                if (iterator instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)iterator)).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        super.produceOutput(result, requestMessage);
    }

    @Override
    public String getComponentType() {
        return "splitter";
    }

    protected abstract Object splitMessage(Message<?> var1);

    private /* synthetic */ AbstractIntegrationMessageBuilder lambda$handleRequestMessage$1(Map headers, Object correlationId, AtomicInteger sequenceNumber, int sequenceSize, Object object) {
        return this.createBuilder(object, headers, correlationId, sequenceNumber.getAndIncrement(), sequenceSize);
    }

    private static class JacksonNodeHelper {
        private JacksonNodeHelper() {
        }

        private static boolean isNode(Object object) {
            return object instanceof TreeNode;
        }

        private static int nodeSize(Object node) {
            return ((TreeNode)node).size();
        }
    }
}

