/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.transformer.Transformer;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class HeaderEnricher
extends IntegrationObjectSupport
implements Transformer,
BeanNameAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(HeaderEnricher.class);
    private final Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd;
    private volatile MessageProcessor<?> messageProcessor;
    private volatile boolean defaultOverwrite = false;
    private volatile boolean shouldSkipNulls = true;

    public HeaderEnricher() {
        this(null);
    }

    public HeaderEnricher(Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd) {
        this.headersToAdd = headersToAdd != null ? headersToAdd : new HashMap();
    }

    public <T> void setMessageProcessor(MessageProcessor<T> messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setDefaultOverwrite(boolean defaultOverwrite) {
        this.defaultOverwrite = defaultOverwrite;
    }

    public void setShouldSkipNulls(boolean shouldSkipNulls) {
        this.shouldSkipNulls = shouldSkipNulls;
    }

    @Override
    public String getComponentType() {
        return "header-enricher";
    }

    @Override
    public Message<?> transform(Message<?> message) {
        MessageHeaders messageHeaders = message.getHeaders();
        AbstractIntegrationMessageBuilder<?> messageBuilder = this.getMessageBuilderFactory().fromMessage(message);
        this.addHeadersFromMessageProcessor(message, messageBuilder);
        for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headersToAdd.entrySet()) {
            Object value;
            boolean headerDoesNotExist;
            String key = entry.getKey();
            HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
            Boolean shouldOverwrite = valueProcessor.isOverwrite();
            if (shouldOverwrite == null) {
                shouldOverwrite = this.defaultOverwrite;
            }
            boolean bl = headerDoesNotExist = messageHeaders.get((Object)key) == null;
            if (!headerDoesNotExist && !shouldOverwrite.booleanValue() || (value = valueProcessor.processMessage(message)) == null && this.shouldSkipNulls) continue;
            messageBuilder.setHeader(key, value);
        }
        return messageBuilder.build();
    }

    private void addHeadersFromMessageProcessor(Message<?> message, AbstractIntegrationMessageBuilder<?> messageBuilder) {
        if (this.messageProcessor != null) {
            Object result = this.messageProcessor.processMessage(message);
            if (result instanceof Map) {
                MessageHeaders messageHeaders = message.getHeaders();
                Map resultMap = (Map)result;
                for (Map.Entry entry : resultMap.entrySet()) {
                    Object key = entry.getKey();
                    if (key instanceof String) {
                        if (!this.defaultOverwrite && messageHeaders.get(key) != null) continue;
                        messageBuilder.setHeader((String)key, entry.getValue());
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("ignoring value for non-String key: " + key));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("expected a Map result from processor, but received: " + result));
            }
        }
    }

    @Override
    public void onInit() {
        boolean shouldOverwrite = this.defaultOverwrite;
        boolean checkReadOnlyHeaders = this.getMessageBuilderFactory() instanceof DefaultMessageBuilderFactory;
        for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headersToAdd.entrySet()) {
            Boolean processorOverwrite;
            if (checkReadOnlyHeaders && ("id".equals(entry.getKey()) || "timestamp".equals(entry.getKey()))) {
                throw new BeanInitializationException("HeaderEnricher cannot override 'id' and 'timestamp' read-only headers.\nWrong 'headersToAdd' [" + this.headersToAdd + "] configuration for " + this.getComponentName());
            }
            HeaderValueMessageProcessor<?> processor = entry.getValue();
            if (processor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
                ((BeanFactoryAware)processor).setBeanFactory(this.getBeanFactory());
            }
            if ((processorOverwrite = processor.isOverwrite()) == null) continue;
            shouldOverwrite |= processorOverwrite.booleanValue();
        }
        if (this.messageProcessor != null && this.messageProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (!shouldOverwrite && !this.shouldSkipNulls && logger.isWarnEnabled()) {
            logger.warn((Object)(this.getComponentName() + " is configured to not overwrite existing headers. 'shouldSkipNulls = false' will have no effect"));
        }
    }
}

