/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.java.decompiler.DecompilerAdapter;
import org.jboss.windup.interrogator.impl.ExtensionInterrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.JavaMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.BlacklistPackageResolver;
import org.jboss.windup.util.CustomerPackageResolver;
import org.jboss.windup.util.FatalWindupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInterrogator
extends ExtensionInterrogator<JavaMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassInterrogator.class);
    private DecompilerAdapter decompiler;
    private BlacklistPackageResolver blacklistPackageResolver;
    private CustomerPackageResolver customerPackageResolver;

    public void setBlacklistPackageResolver(BlacklistPackageResolver blacklistPackageResolver) {
        this.blacklistPackageResolver = blacklistPackageResolver;
    }

    public void setDecompiler(DecompilerAdapter decompiler) {
        this.decompiler = decompiler;
    }

    public void setCustomerPackageResolver(CustomerPackageResolver customerPackageResolver) {
        this.customerPackageResolver = customerPackageResolver;
    }

    @Override
    public JavaMetadata archiveEntryToMeta(ZipEntryMetadata archiveEntry) {
        String className = this.extractClassName(archiveEntry.getZipEntry().getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class: " + className + " " + this.customerPackageResolver.isCustomerPkg(className));
        }
        if (!this.customerPackageResolver.isCustomerPkg(className)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Class: " + className + " is not a customer package.");
            }
            return null;
        }
        Set<String> clzImports = this.extractImports(archiveEntry);
        if (this.blacklistPackageResolver.containsGenerated(clzImports)) {
            LOG.trace("Class is generated.  Skip profiling.");
            return null;
        }
        if (!this.blacklistPackageResolver.containsBlacklist(clzImports)) {
            LOG.trace("Class does not contain blacklists.");
            return null;
        }
        return this.extractJavaFile(className, clzImports, archiveEntry);
    }

    private JavaMetadata extractJavaFile(String className, Set<String> clzImports, ZipEntryMetadata archiveEntry) {
        JavaMetadata javaMeta = new JavaMetadata();
        try {
            File javaFile;
            ZipMetadata zipMeta = (ZipMetadata)archiveEntry.getArchiveMeta();
            ZipFile zipFile = zipMeta.getZipFile();
            ZipEntry entry = archiveEntry.getZipEntry();
            String javaZipEntry = StringUtils.removeEnd((String)entry.getName(), (String)".class") + ".java";
            if (zipFile.getEntry(javaZipEntry) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found Java in archive: " + className);
                }
                ZipEntry javaEntry = zipFile.getEntry(javaZipEntry);
                archiveEntry.setZipEntry(javaEntry);
                javaFile = archiveEntry.getFilePointer();
            } else {
                File clzFile = archiveEntry.getFilePointer();
                javaFile = new File(StringUtils.substringBeforeLast((String)clzFile.getAbsolutePath(), (String)".class") + ".java");
                File javaPathFile = new File(StringUtils.substringBeforeLast((String)clzFile.getAbsolutePath(), (String)File.separator));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Did not find class in archive. Decompiling class: " + className);
                }
                this.decompiler.decompile(className, clzFile, javaPathFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unzipped class: " + className);
                }
            }
            javaMeta.setFilePointer(javaFile);
            javaMeta.setArchiveMeta(archiveEntry.getArchiveMeta());
            javaMeta.setClassDependencies(clzImports);
            javaMeta.setQualifiedClassName(className);
            javaMeta.setBlackListedDependencies(this.blacklistPackageResolver.extractBlacklist(clzImports));
            return javaMeta;
        }
        catch (Exception e) {
            if (e instanceof FatalWindupException) {
                throw (FatalWindupException)e;
            }
            LOG.error("Error extracting java file: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Set<String> extractImports(ZipEntryMetadata archiveEntry) {
        try {
            ZipMetadata zipMeta = (ZipMetadata)archiveEntry.getArchiveMeta();
            ZipFile zipFile = zipMeta.getZipFile();
            ZipEntry entry = archiveEntry.getZipEntry();
            CtClass ctClz = new ClassPool().makeClass(zipFile.getInputStream(entry));
            if (LOG.isDebugEnabled()) {
                for (String clz : ctClz.getClassFile2().getInterfaces()) {
                    LOG.debug("Interfaces: " + clz);
                }
                LOG.debug("Super Class: " + ctClz.getClassFile2().getSuperclass());
            }
            HashSet<String> clzImports = new HashSet<String>(ClassInterrogator.castList(String.class, ctClz.getRefClasses()));
            return clzImports;
        }
        catch (Exception e) {
            LOG.error("Error extractine imports: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> castList(Class<? extends T> aclass, Collection<?> c) {
        ArrayList<T> r = new ArrayList<T>(c.size());
        for (Object o : c) {
            r.add(aclass.cast(o));
        }
        return r;
    }

    protected String extractClassName(String entryName) {
        String className = StringUtils.replace((String)entryName, (String)"\\", (String)"/");
        className = StringUtils.removeStart((String)className, (String)"/");
        className = StringUtils.replace((String)className, (String)"/", (String)".");
        className = StringUtils.removeEnd((String)className, (String)".class");
        className = StringUtils.removeEnd((String)className, (String)".java");
        if (StringUtils.contains((String)(className = StringUtils.substringBefore((String)className, (String)"$")), (String)"WEB-INF.classes.")) {
            className = StringUtils.substringAfter((String)className, (String)"WEB-INF.classes.");
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JavaMetadata fileEntryToMeta(FileMetadata entry) {
        JavaMetadata javaMetadata;
        HashSet<String> clzImports;
        CtClass ctClazz;
        FileInputStream fis;
        JavaMetadata javaMeta;
        block10: {
            block9: {
                block8: {
                    javaMeta = new JavaMetadata();
                    javaMeta.setArchiveMeta(entry.getArchiveMeta());
                    fis = null;
                    fis = new FileInputStream(entry.getFilePointer());
                    javaMeta.setFilePointer(entry.getFilePointer());
                    ctClazz = new ClassPool().makeClass((InputStream)fis);
                    String className = ctClazz.getName();
                    if (this.customerPackageResolver.isCustomerPkg(className)) break block8;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Class: " + className + " is not a customer package.");
                    }
                    JavaMetadata javaMetadata2 = null;
                    IOUtils.closeQuietly((InputStream)fis);
                    return javaMetadata2;
                }
                clzImports = new HashSet<String>(ClassInterrogator.castList(String.class, ctClazz.getRefClasses()));
                if (!this.blacklistPackageResolver.containsGenerated(clzImports)) break block9;
                LOG.trace("Class is generated.  Skip profiling.");
                JavaMetadata javaMetadata3 = null;
                IOUtils.closeQuietly((InputStream)fis);
                return javaMetadata3;
            }
            if (this.blacklistPackageResolver.containsBlacklist(clzImports)) break block10;
            LOG.trace("Class does not contain blacklists.");
            JavaMetadata javaMetadata4 = null;
            IOUtils.closeQuietly((InputStream)fis);
            return javaMetadata4;
        }
        try {
            javaMeta.setClassDependencies(clzImports);
            javaMeta.setQualifiedClassName(ctClazz.getName());
            javaMeta.setBlackListedDependencies(this.blacklistPackageResolver.extractBlacklist(clzImports));
            javaMetadata = javaMeta;
        }
        catch (Exception e) {
            try {
                LOG.error("Exception processing file: " + entry.getFilePointer().getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return null;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return javaMetadata;
    }
}

