/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;

public class ConnectedMultiFieldsRangeQueryBuilder
implements RangeTerminationExcludable {
    private final RangeQueryContext rangeContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldContext> fieldContexts;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsRangeQueryBuilder(RangeQueryContext rangeContext, QueryCustomizer queryCustomizer, List<FieldContext> fieldContexts, QueryBuildingContext queryContext) {
        this.rangeContext = rangeContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
        this.queryContext = queryContext;
    }

    @Override
    public RangeTerminationExcludable excludeLimit() {
        if (this.rangeContext.getFrom() != null && this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getFrom() != null) {
            this.rangeContext.setExcludeFrom(true);
        } else if (this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else {
            throw new AssertionFailure("Both from and to clause of a range query are null");
        }
        return this;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0), conversionContext)).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext, conversionContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    private Query createQuery(FieldContext fieldContext, ConversionContext conversionContext) {
        String fieldName = fieldContext.getField();
        DocumentBuilderIndexedEntity documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        DocumentFieldMetadata fieldMetadata = documentBuilder.getTypeMetadata().getDocumentFieldMetadataFor(fieldName);
        Query perFieldQuery = fieldMetadata != null ? (fieldMetadata.isNumeric() ? ConnectedMultiFieldsRangeQueryBuilder.createNumericRangeQuery(fieldName, this.rangeContext) : ConnectedMultiFieldsRangeQueryBuilder.createKeywordRangeQuery(fieldName, this.rangeContext, this.queryContext, conversionContext, fieldContext)) : (this.rangeBoundaryTypeRequiredNumericQuery(this.rangeContext.getFrom(), this.rangeContext.getTo()) ? ConnectedMultiFieldsRangeQueryBuilder.createNumericRangeQuery(fieldName, this.rangeContext) : ConnectedMultiFieldsRangeQueryBuilder.createKeywordRangeQuery(fieldName, this.rangeContext, this.queryContext, conversionContext, fieldContext));
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private boolean rangeBoundaryTypeRequiredNumericQuery(Object from, Object to) {
        if (from != null) {
            return NumericFieldUtils.requiresNumericRangeQuery(from);
        }
        if (to != null) {
            return NumericFieldUtils.requiresNumericRangeQuery(to);
        }
        return false;
    }

    private static Query createKeywordRangeQuery(String fieldName, RangeQueryContext rangeContext, QueryBuildingContext queryContext, ConversionContext conversionContext, FieldContext fieldContext) {
        Analyzer queryAnalyzer = queryContext.getQueryAnalyzer();
        DocumentBuilderIndexedEntity documentBuilder = Helper.getDocumentBuilder(queryContext);
        String fromString = rangeContext.hasFrom() ? fieldContext.objectToString(documentBuilder, rangeContext.getFrom(), conversionContext) : null;
        String lowerTerm = fromString == null ? null : Helper.getAnalyzedTerm(fieldName, fromString, "from", queryAnalyzer, fieldContext);
        String toString = rangeContext.hasTo() ? fieldContext.objectToString(documentBuilder, rangeContext.getTo(), conversionContext) : null;
        String upperTerm = toString == null ? null : Helper.getAnalyzedTerm(fieldName, toString, "to", queryAnalyzer, fieldContext);
        return TermRangeQuery.newStringRange((String)fieldName, (String)lowerTerm, (String)upperTerm, (!rangeContext.isExcludeFrom() ? 1 : 0) != 0, (!rangeContext.isExcludeTo() ? 1 : 0) != 0);
    }

    private static Query createNumericRangeQuery(String fieldName, RangeQueryContext rangeContext) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, rangeContext.getFrom(), rangeContext.getTo(), !rangeContext.isExcludeFrom(), !rangeContext.isExcludeTo());
    }
}

