/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.hint;

import java.util.regex.Pattern;
import org.jboss.windup.hint.ResultProcessor;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.StoryPointEffort;
import org.jboss.windup.metadata.decoration.hint.MarkdownHint;

public class RegexPatternHintProcessor
implements ResultProcessor {
    protected Pattern regexPattern;
    protected String hint;
    protected AbstractDecoration.NotificationLevel notificationLevel;
    protected Effort effort;

    public void setNotificationLevel(String notificationLevel) {
        this.notificationLevel = AbstractDecoration.NotificationLevel.valueOf((String)notificationLevel);
    }

    public void setEffort(int effort) {
        this.effort = new StoryPointEffort(Integer.valueOf(effort));
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getHint() {
        return this.hint;
    }

    public void setRegexPattern(Pattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    @Override
    public void process(AbstractDecoration result) {
        if (this.regexPattern.matcher(result.getPattern()).find()) {
            MarkdownHint sh = new MarkdownHint();
            sh.setMarkdown(this.hint);
            result.getHints().add(sh);
            if (this.notificationLevel != null) {
                result.setLevel(this.notificationLevel);
            }
            if (this.effort != null) {
                result.setEffort(this.effort);
            }
        }
    }
}

