/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementUtil {
    private XmlElementUtil() {
    }

    public static Element getChildByTagName(Element element, String tagName) {
        List<Element> elements = XmlElementUtil.getChildrenByTagName(element, tagName);
        if (elements == null || elements.size() == 0) {
            return null;
        }
        return elements.get(0);
    }

    public static List<Element> getChildElements(Element element) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList children = element.getChildNodes();
        if (children == null) {
            return elements;
        }
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static List<Element> getChildrenByTagName(Element element, String tagName) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList children = element.getChildNodes();
        if (children == null) {
            return elements;
        }
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !StringUtils.equals((String)child.getLocalName(), (String)tagName)) continue;
            elements.add((Element)child);
        }
        return elements;
    }
}

