/*
 * Decompiled with CFR 0.152.
 */
package org.acme.resteasyjackson;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/resteasy-jackson/quarks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JacksonResource {
    private final Set<Quark> quarks = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap()));

    public JacksonResource() {
        this.quarks.add(new Quark("Up", "The up quark or u quark (symbol: u) is the lightest of all quarks, a type of elementary particle, and a major constituent of matter."));
        this.quarks.add(new Quark("Strange", "The strange quark or s quark (from its symbol, s) is the third lightest of all quarks, a type of elementary particle."));
        this.quarks.add(new Quark("Charm", "The charm quark, charmed quark or c quark (from its symbol, c) is the third most massive of all quarks, a type of elementary particle."));
        this.quarks.add(new Quark("???", null));
    }

    @GET
    public Set<Quark> list() {
        return this.quarks;
    }

    @POST
    public Set<Quark> add(Quark quark) {
        this.quarks.add(quark);
        return this.quarks;
    }

    @DELETE
    public Set<Quark> delete(Quark quark) {
        this.quarks.removeIf(existingQuark -> existingQuark.name.contentEquals(quark.name));
        return this.quarks;
    }

    public static class Quark {
        public String name;
        public String description;

        public Quark() {
        }

        public Quark(String name, String description) {
            this.name = name;
            this.description = description;
        }
    }
}

