/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.decorator.archive.PomVersionDecorator;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;

public class PomDescriptionDecorator
implements MetaDecorator<XmlMetadata>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PomVersionDecorator.class);
    private static final XPathFactory factory = XPathFactory.newInstance();
    private static final String DESCRIPTION = "/*[local-name()='project']/*[local-name()='description']";
    protected XPathExpression xPath;

    @Override
    public void processMeta(XmlMetadata file) {
        Document doc = file.getParsedDocument();
        try {
            String description = this.extractStringValue(this.xPath, doc);
            if (StringUtils.isNotBlank((String)description)) {
                Summary result = new Summary();
                result.setDescription(description);
                file.getArchiveMeta().getDecorations().add(result);
            }
        }
        catch (XPathExpressionException e) {
            LOG.error("Exception running xpath expression.", (Throwable)e);
        }
    }

    protected String extractStringValue(XPathExpression expression, Document doc) throws XPathExpressionException {
        return (String)expression.evaluate(doc, XPathConstants.STRING);
    }

    public void afterPropertiesSet() throws Exception {
        XPath xpath = factory.newXPath();
        this.xPath = xpath.compile(DESCRIPTION);
    }
}

