/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class Menu
extends MenuItem
implements MenuContainer,
Accessible {
    Vector<MenuComponent> items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public Menu() throws HeadlessException {
        this("", false);
    }

    public Menu(String label) throws HeadlessException {
        this(label, false);
    }

    public Menu(String label, boolean tearOff) throws HeadlessException {
        super(label);
        this.tearOff = tearOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Menu> clazz = Menu.class;
        synchronized (Menu.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenu(this);
            }
            int nitems = this.getItemCount();
            for (int i = 0; i < nitems; ++i) {
                MenuItem mi = this.getItem(i);
                mi.parent = this;
                mi.addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int nitems = this.getItemCount();
            for (int i = 0; i < nitems; ++i) {
                this.getItem(i).removeNotify();
            }
            super.removeNotify();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.countItemsImpl();
    }

    final int countItemsImpl() {
        return this.items.size();
    }

    public MenuItem getItem(int index) {
        return this.getItemImpl(index);
    }

    final MenuItem getItemImpl(int index) {
        return (MenuItem)this.items.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem add(MenuItem mi) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (mi.parent != null) {
                mi.parent.remove(mi);
            }
            this.items.addElement(mi);
            mi.parent = this;
            MenuPeer peer = (MenuPeer)this.peer;
            if (peer != null) {
                mi.addNotify();
                peer.addItem(mi);
            }
            return mi;
        }
    }

    public void add(String label) {
        this.add(new MenuItem(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MenuItem menuitem, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i;
            if (index < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int nitems = this.getItemCount();
            Vector<MenuItem> tempItems = new Vector<MenuItem>();
            for (i = index; i < nitems; ++i) {
                tempItems.addElement(this.getItem(index));
                this.remove(index);
            }
            this.add(menuitem);
            for (i = 0; i < tempItems.size(); ++i) {
                this.add((MenuItem)tempItems.elementAt(i));
            }
        }
    }

    public void insert(String label, int index) {
        this.insert(new MenuItem(label), index);
    }

    public void addSeparator() {
        this.add("-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSeparator(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i;
            if (index < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int nitems = this.getItemCount();
            Vector<MenuItem> tempItems = new Vector<MenuItem>();
            for (i = index; i < nitems; ++i) {
                tempItems.addElement(this.getItem(index));
                this.remove(index);
            }
            this.addSeparator();
            for (i = 0; i < tempItems.size(); ++i) {
                this.add((MenuItem)tempItems.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItem mi = this.getItem(index);
            this.items.removeElementAt(index);
            MenuPeer peer = (MenuPeer)this.peer;
            if (peer != null) {
                peer.delItem(index);
                mi.removeNotify();
                mi.parent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MenuComponent item) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int index = this.items.indexOf(item);
            if (index >= 0) {
                this.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int nitems = this.getItemCount();
            for (int i = nitems - 1; i >= 0; --i) {
                this.remove(i);
            }
        }
    }

    @Override
    boolean handleShortcut(KeyEvent e) {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            MenuItem mi = this.getItem(i);
            if (!mi.handleShortcut(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    MenuItem getShortcutMenuItem(MenuShortcut s) {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            MenuItem mi = this.getItem(i).getShortcutMenuItem(s);
            if (mi == null) continue;
            return mi;
        }
        return null;
    }

    synchronized Enumeration<MenuShortcut> shortcuts() {
        Vector<MenuShortcut> shortcuts = new Vector<MenuShortcut>();
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            MenuItem mi = this.getItem(i);
            if (mi instanceof Menu) {
                Enumeration<MenuShortcut> e = ((Menu)mi).shortcuts();
                while (e.hasMoreElements()) {
                    shortcuts.addElement(e.nextElement());
                }
                continue;
            }
            MenuShortcut ms = mi.getShortcut();
            if (ms == null) continue;
            shortcuts.addElement(ms);
        }
        return shortcuts.elements();
    }

    @Override
    void deleteShortcut(MenuShortcut s) {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            this.getItem(i).deleteShortcut(s);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, HeadlessException {
        s.defaultReadObject();
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem item = (MenuItem)this.items.elementAt(i);
            item.parent = this;
        }
    }

    @Override
    public String paramString() {
        String str = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return super.paramString() + str;
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    @Override
    int getAccessibleChildIndex(MenuComponent child) {
        return this.items.indexOf(child);
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Menu.initIDs();
        }
        AWTAccessor.setMenuAccessor(new AWTAccessor.MenuAccessor(){

            public Vector<MenuComponent> getItems(Menu menu) {
                return menu.items;
            }
        });
        nameCounter = 0;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private static final long serialVersionUID = 5228160894980069094L;

        protected AccessibleAWTMenu() {
            super(Menu.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

