/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.spatial.impl.SpatialNumericDocValueField;

public class SpatialFieldBridgeByRange
extends SpatialFieldBridge {
    public SpatialFieldBridgeByRange() {
    }

    public SpatialFieldBridgeByRange(String latitudeField, String longitudeField) {
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                String latitudeFieldName = SpatialHelper.formatLatitude(name);
                String longitudeFieldName = SpatialHelper.formatLongitude(name);
                luceneOptions.addNumericFieldToDocument(latitudeFieldName, latitude, document);
                luceneOptions.addNumericFieldToDocument(longitudeFieldName, longitude, document);
                SpatialNumericDocValueField latitudeDocValuesField = new SpatialNumericDocValueField(latitudeFieldName, latitude);
                document.add((IndexableField)latitudeDocValuesField);
                SpatialNumericDocValueField longitudeDocValuesField = new SpatialNumericDocValueField(longitudeFieldName, longitude);
                document.add((IndexableField)longitudeDocValuesField);
            }
        }
    }
}

