/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.stats;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExceptionInfoStats
implements Serializable {
    private static final long serialVersionUID = -9181009739048456265L;
    private String name;
    private long count;
    private Map<Long, String> exceptionData = Collections.synchronizedMap(new HashMap());

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public Map<Long, String> getExceptionData() {
        return this.exceptionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionData(long count, int threadId, Date date, String euDesc, String exMessage, int maxMsgSize, int exceptionMaxCount) {
        if (maxMsgSize < 0) {
            maxMsgSize = 0;
        }
        if (exceptionMaxCount != 0) {
            if (exceptionMaxCount > 0 && count - (long)exceptionMaxCount > 0L) {
                Map<Long, String> map = this.exceptionData;
                synchronized (map) {
                    this.exceptionData.remove(count - (long)exceptionMaxCount);
                }
            }
            this.exceptionData.put(count, this.buildExceptionData(threadId, date, euDesc, exMessage, maxMsgSize));
        }
    }

    private String buildExceptionData(int threadId, Date date, String euDesc, String exMessage, int maxMsgSize) {
        StringBuffer sb = new StringBuffer("Thread id: ").append(threadId);
        String dateInfo = date == null ? ".  Date: unknown" : ".  Date: " + date.toString();
        sb.append(dateInfo);
        sb.append(".  Execution Unit Desc: ").append(euDesc);
        String msg = ".  Message: exception has no message ";
        msg = exMessage != null && exMessage.length() > maxMsgSize ? ".  Message: (truncated to: " + maxMsgSize + " chars): " + exMessage.substring(0, maxMsgSize) : (exMessage != null ? ".  Message: " + exMessage : "(framework note: the exception message provided was null, framework replaced it by this text)");
        sb.append(msg);
        return sb.toString();
    }
}

