/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IConfigData;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractSingletonExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.UUID;

public class CRUDConfigDataEU
extends AbstractSingletonExecutionUnit {
    private static final long serialVersionUID = -4657309483111671699L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        IConfigData configData = null;
        this.logger.fine("Retrieve Initial ConfigData");
        try {
            configData = this.retrieveConfigData();
        }
        catch (Exception e) {
            this.logger.warning("Failed to retrieve ConfigData. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying retrieve ConfigData");
        try {
            this.verifyRetrieve(configData);
        }
        catch (Exception e) {
            this.logger.info("Retrieve ConfigData verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        configData = null;
        this.logger.fine("Creating New ConfigData");
        try {
            configData = this.createConfigData();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create new ConfigData. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create New ConfigData");
        try {
            this.verifyCreate(configData);
        }
        catch (Exception e) {
            this.logger.info("Create New ConfigData verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating ConfigData");
        IConfigData updated = null;
        try {
            updated = this.updateConfigData(configData);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update ConfigData. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update ConfigData");
        try {
            this.verifyUpdate(updated);
        }
        catch (Exception e) {
            this.logger.info("Update ConfigData verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting ConfigData");
        try {
            this.deleteConfigData(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete ConfigData. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete ConfigData");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete ConfigData verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IConfigData retrieveConfigData() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IConfigData configData = BasicExecutionUnitLibrarry.getConfigData(this.getAnnuityBeansFactory());
        configData.setConfiguration(this.getConfiguration());
        configData = this.getServerAdapter().getServerConfigData(configData);
        return configData;
    }

    private IConfigData createConfigData() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IConfigData configData = BasicExecutionUnitLibrarry.getConfigData(this.getAnnuityBeansFactory());
        configData.setConfiguration(this.getConfiguration());
        configData.setId(UUID.randomUUID().toString());
        configData = this.getServerAdapter().createConfigData(configData);
        return configData;
    }

    private IConfigData updateConfigData(IConfigData before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IConfigData after = BasicExecutionUnitLibrarry.getConfigData(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findConfigDataById(after);
        Map<String, String> updatedMap = after.getConfigMap();
        updatedMap.put("Updated", "Updated");
        after.setConfigMap(updatedMap);
        after.getConfigMap();
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateConfigData(after);
        return after;
    }

    private void deleteConfigData(IConfigData configData) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IConfigData removed = BasicExecutionUnitLibrarry.getConfigData(this.getAnnuityBeansFactory());
        removed.setId(configData.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteConfigData(removed);
    }

    private void verifyRetrieve(IConfigData configData) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        ExecutionUnitVerificationHelper.assertValidId((IExecutionUnit)this, configData, "ConfigData retrieved from server NOT valid", "ConfigData Retrieve mismatch.");
    }

    private void verifyCreate(IConfigData configData) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IConfigData results = this.getAnnuityBeansFactory().createConfigData();
        results.setId(configData.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findConfigDataById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, configData, results, "ConfigData from client is not equal to DB value", "ConfigData Create mismacth was found.");
    }

    private void verifyUpdate(IConfigData configData) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IConfigData results = this.getAnnuityBeansFactory().createConfigData();
        results.setId(configData.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findConfigDataById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, configData, results, "ConfigData from client is not equal to DB value", "ConfigData Update mismacth was found.");
    }

    private void verifyDelete(IConfigData configData) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IConfigData results = this.getAnnuityBeansFactory().createConfigData();
        results.setId(configData.getId());
        results.setConfiguration(this.getConfiguration());
        try {
            results = this.getServerAdapter().findConfigDataById(results);
            if (results != null) {
                throw new ExecutionUnitVerificationException("Deletion of ConfigData with ID = " + (String)configData.getId() + "was not successful! The object still exists in DB.");
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }
}

