/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter;

import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityObject;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Address;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Annuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.AnnuityPersistebleObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Entry;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Payout;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.RiderType;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.StringParameterizable;
import com.ibm.wssvt.acme.common.bean.Configrable;
import java.util.Calendar;
import java.util.Date;

public class JavaBeanToJaxrpcClientBean {
    public static Address getAddress(IAddress in) {
        if (in == null) {
            return null;
        }
        Address out = new Address();
        out.setCity(in.getCity());
        out.setCountry(in.getCountry());
        out.setLine1(in.getLine1());
        out.setLine2(in.getLine2());
        out.setState(in.getState());
        out.setZipCode(in.getZipCode());
        return out;
    }

    public static Contact getContact(IContact in) {
        if (in == null) {
            return null;
        }
        Contact out = new Contact();
        out.setEmail(in.getEmail());
        out.setPhone(in.getPhone());
        out.setAddress(JavaBeanToJaxrpcClientBean.getAddress(in.getAddress()));
        if (in.getContactType() != null) {
            out.setContactType(ContactType.fromString(in.getContactType().toString()));
        }
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        return out;
    }

    public static AnnuityHolder getAnnuityHolder(IAnnuityHolder in) {
        if (in == null) {
            return null;
        }
        AnnuityHolder out = new AnnuityHolder();
        if (in.getCategory() != null) {
            out.setCategory(AnnuityHolderCategory.fromString(in.getCategory().toString()));
        }
        out.setContact(JavaBeanToJaxrpcClientBean.getContact(in.getContact()));
        out.setDateOfBirth(Calendar.getInstance());
        JavaBeanToJaxrpcClientBean.dateToCalendar(in.getDateOfBirth(), out.getDateOfBirth());
        out.setFirstName(in.getFirstName());
        out.setLastName(in.getLastName());
        out.setGovernmentId(in.getGovernmentId());
        if (in.getPicture() == null) {
            out.setPicture(null);
        } else {
            byte[] picArray = new byte[in.getPicture().length];
            for (int i = 0; i < in.getPicture().length; ++i) {
                picArray[i] = in.getPicture()[i];
            }
            out.setPicture(picArray);
        }
        out.setTimeOfBirth(Calendar.getInstance());
        JavaBeanToJaxrpcClientBean.dateToCalendar(in.getTimeOfBirth(), out.getTimeOfBirth());
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        return out;
    }

    public static Annuity getAnnuity(IAnnuity in) {
        AnnuityPersistebleObject p;
        int i;
        Annuity out;
        if (in == null) {
            return null;
        }
        if (in instanceof IFixedAnnuity) {
            out = new FixedAnnuity();
            ((FixedAnnuity)out).setRate(((IFixedAnnuity)in).getRate());
        } else if (in instanceof IEquityAnnuity) {
            out = new EquityAnnuity();
            ((EquityAnnuity)out).setFundNames(((IEquityAnnuity)in).getFundNames());
            ((EquityAnnuity)out).setIndexRate(((IEquityAnnuity)in).getIndexRate());
        } else {
            out = new Annuity();
        }
        out.setAccountNumber(in.getAccountNumber());
        out.setAmount(in.getAmount());
        out.setAnnuityHolderId(in.getAnnuityHolderId());
        out.setLastPaidAmt(in.getLastPaidAmt());
        if (in.getPayors() != null) {
            Payor[] payorList = new Payor[in.getPayors().size()];
            for (i = 0; i < in.getPayors().size(); ++i) {
                p = JavaBeanToJaxrpcClientBean.getPayor(in.getPayors().get(i));
                payorList[i] = p;
            }
            out.setPayors(payorList);
        }
        if (in.getRiders() != null) {
            Rider[] riderList = new Rider[in.getRiders().size()];
            for (i = 0; i < in.getRiders().size(); ++i) {
                Rider r;
                riderList[i] = r = JavaBeanToJaxrpcClientBean.getRider(in.getRiders().get(i));
            }
            out.setRiders(riderList);
        }
        if (in.getPayouts() != null) {
            Payout[] payoutList = new Payout[in.getPayouts().size()];
            for (i = 0; i < in.getPayouts().size(); ++i) {
                p = JavaBeanToJaxrpcClientBean.getPayoutWithNoAnnuity(in.getPayouts().get(i));
                payoutList[i] = p;
                ((Payout)p).setAnnuity(out);
            }
            out.setPayouts(payoutList);
        }
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        return out;
    }

    public static Payout getPayoutWithNoAnnuity(IPayout in) {
        if (in == null) {
            return null;
        }
        Payout out = new Payout();
        out.setTaxableAmount(in.getTaxableAmount());
        out.setEndDate(in.getEndDate());
        out.setStartDate(in.getStartDate());
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        return out;
    }

    public static Payout getPayout(IPayout in) {
        if (in == null) {
            return null;
        }
        Payout out = JavaBeanToJaxrpcClientBean.getPayoutWithNoAnnuity(in);
        out.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(in.getAnnuity()));
        return out;
    }

    public static Rider getRider(IRider in) {
        if (in == null) {
            return null;
        }
        Rider out = new Rider();
        out.setRule(in.getRule());
        out.setEffectiveDate(Calendar.getInstance());
        JavaBeanToJaxrpcClientBean.dateToCalendar(in.getEffectiveDate(), out.getEffectiveDate());
        out.setType(RiderType.fromString(in.getType().toString()));
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        return out;
    }

    public static Payor getPayor(IPayor in) {
        if (in == null) {
            return null;
        }
        Payor out = new Payor();
        out.setName(in.getName());
        JavaBeanToJaxrpcClientBean.setAnnuityObjectAtts(in, out);
        JavaBeanToJaxrpcClientBean.setConfigrableAtts(in, out);
        return out;
    }

    public static void dateToCalendar(Date in, Calendar out) {
        if (in == null) {
            out = null;
        } else {
            out.setTime(in);
        }
    }

    public static void setAnnuityObjectAtts(IAnnuityObject in, AnnuityPersistebleObject out) {
        out.setId((String)in.getId());
        out.setVersion(in.getVersion());
        out.setLastUpdateDate(Calendar.getInstance());
        JavaBeanToJaxrpcClientBean.dateToCalendar(in.getLastUpdateDate(), out.getLastUpdateDate());
    }

    public static void setConfigrableAtts(Configrable<String, String> in, AnnuityPersistebleObject out) {
        if (in.getConfiguration() == null || in.getConfiguration().getParameters() == null) {
            return;
        }
        StringParameterizable sp = new StringParameterizable();
        Entry[] entryList = new Entry[in.getConfiguration().getParameters().size()];
        int cntr = 0;
        for (String key : in.getConfiguration().getParameters().keySet()) {
            Entry entry = new Entry();
            entry.setKey(key);
            entry.setValue((String)in.getConfiguration().getParameterValue((Object)key));
            entryList[cntr] = entry;
            ++cntr;
        }
        sp.setParams(entryList);
        out.setConfig(sp);
    }
}

