/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2ejb3jaxws;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.AnnuityMgmtSvcEJB30JAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.AnnuityMgmtSvcEJB30JAXWSImpl;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.AnnuityMgmtSvcEJB30JAXWSImplLocator;
import com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2ejb3jaxws.AnnuityJAXRPCToEjb3JAXWSServiceProxy;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;

public class JAXRPCToEjb3JAXWSServiceLookup {
    private static final String JAXWS_SERVICE_URL_KEY = "JAXWSServiceURL";

    public static IAnnuityService getAnnuityJAXWSService(AnnuityMgmtSvcEJB30JAXWSImpl injectedService, Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException {
        String jaxwsServiceURL = (String)configrable.getConfiguration().getParameterValue((Object)JAXWS_SERVICE_URL_KEY);
        try {
            AnnuityMgmtSvcEJB30JAXWS port;
            if (injectedService != null) {
                logger.fine("using injected service: " + injectedService);
                URL endPoint = new URL(jaxwsServiceURL);
                port = injectedService.getAnnuityMgmtSvcEJB3JAXWSImplPort(endPoint);
                logger.fine("using injected service port: " + port);
            } else {
                URL endPoint = new URL(jaxwsServiceURL);
                AnnuityMgmtSvcEJB30JAXWSImplLocator locator = new AnnuityMgmtSvcEJB30JAXWSImplLocator();
                port = locator.getAnnuityMgmtSvcEJB3JAXWSImplPort(endPoint);
                logger.fine("the ws port is: " + port);
            }
            return new AnnuityJAXRPCToEjb3JAXWSServiceProxy(port);
        }
        catch (MalformedURLException e) {
            logger.info("The url is invalid.  url value is: " + jaxwsServiceURL);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxwsServiceURL + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
        catch (ServiceException e) {
            logger.info("Service Exception - The url is invalid.  url value is: " + jaxwsServiceURL);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxwsServiceURL + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
    }
}

