/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2ejb3jaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2ejb3jaxrpc.JAXWS2Ejb3JAXRPCClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2ejb3jaxrpc.JavaBeanToJAXWS2Ejb3JAXRPCClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityMgmtSvcEJB3JAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ArrayOfTns2NillableAnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.EntityAlreadyExistsException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.EntityNotFoundException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.InvalidArgumentException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ServerBusinessModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ServerPersistenceModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.util.ArrayList;
import java.util.List;

public class AnnuityJAXWSToEjb3JAXRPCServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcEJB3JAXRPCSEI webService;

    public AnnuityJAXWSToEjb3JAXRPCServiceProxy(AnnuityMgmtSvcEJB3JAXRPCSEI webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        if (e instanceof InvalidArgumentException_Exception) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException_Exception) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException_Exception) {
            throw new ServerPersistenceModuleException(e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(ann);
            result = this.webService.createAnnuity(annuityValueObject);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.findAnnuityById(annuityValueObject);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.findAnnuityHolder(annuityValueObject);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            ArrayOfTns2NillableAnnuityValueObject result = this.webService.findHolderAnnuities(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annuityHolder));
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject avo : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(avo.getAnnuityData()));
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return returnData;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            ArrayOfTns2NillableAnnuityValueObject result = this.webService.findPayorAnnuities(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject object : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(object.getAnnuityData()));
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return returnData;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            result = this.webService.findPayoutById(in);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getRider(rider));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            result = this.webService.createPayout(in);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            this.webService.deleteAnnuity(annuityValueObject);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteContact(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deletePayor(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            this.webService.deletePayout(in);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteRider(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getRider(rider));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.updateAnnuity(annuityValueObject);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            result = this.webService.updatePayout(in);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    private AnnuityValueObject getAnnuityValueObject(IAnnuity annuity) {
        if (annuity == null) {
            return null;
        }
        AnnuityValueObject out = new AnnuityValueObject();
        out.setAnnuity(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuity(annuity));
        return out;
    }
}

