/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.adapter.AbstractAnnuityServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.AnnuityPerisstenceFactory;
import com.ibm.wssvt.acme.annuity.common.persistence.AnnuityPersistence;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.List;
import java.util.logging.Level;

public class JPASAAdapter
extends AbstractAnnuityServerAdapter {
    private static final long serialVersionUID = -7761738176018995756L;
    private static AnnuityJPAStandAlonePersistenceProxy standAlonePersistence = null;

    @Override
    protected synchronized IAnnuityService getAnnuityService() throws ServerAdapterCommunicationException {
        AcmeLogger logger = this.getLogger(this.getClass().getName());
        try {
            if (standAlonePersistence == null) {
                logger.fine("We are in the JPA SA");
                logger.fine(this.getConfiguration().getParameters().toString());
                AnnuityPersistence<IPersisteble<String>, String, String> annuityPersistence = AnnuityPerisstenceFactory.getAnnuityPersistence((Configrable<String, String>)this, logger);
                standAlonePersistence = new AnnuityJPAStandAlonePersistenceProxy(annuityPersistence);
            }
        }
        catch (ServerPersistenceModuleException e) {
            logger.log(Level.SEVERE, "Failed to get a AnnuityJPAStandAlonePersistenceProxy - error: " + (Object)((Object)e), (Throwable)((Object)e));
            throw new ServerAdapterCommunicationException("Failed to get a AnnuityJPAStandAlonePersistenceProxy ");
        }
        return standAlonePersistence;
    }

    private class AnnuityJPAStandAlonePersistenceProxy
    implements IAnnuityService {
        private AnnuityPersistence<IPersisteble<String>, String, String> annuityPersistence;

        public AnnuityJPAStandAlonePersistenceProxy(AnnuityPersistence<IPersisteble<String>, String, String> persistenceAdapter) {
            this.annuityPersistence = persistenceAdapter;
        }

        @Override
        public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            String id = (String)annuity.getId();
            annuity = (IAnnuity)this.annuityPersistence.readObject(annuity.getClass(), id, annuity);
            return annuity;
        }

        @Override
        public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
            return (IAnnuity)((Object)this.annuityPersistence.updateObject((IPersisteble)((Object)ann)));
        }

        @Override
        public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(annuity.getClass(), annuity.getId(), annuity);
        }

        @Override
        public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IAnnuity)((Object)this.annuityPersistence.createObject((IPersisteble)((Object)ann)));
        }

        @Override
        public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return this.annuityPersistence.getAnnuityHolder(annuity);
        }

        @Override
        public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IContact)this.annuityPersistence.readObject(contact.getClass(), contact.getId(), contact);
        }

        @Override
        public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
            return this.annuityPersistence.getHolderAnnuities(annuityHolder);
        }

        @Override
        public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IAnnuityHolder)this.annuityPersistence.readObject(annuityHolder.getClass(), annuityHolder.getId(), annuityHolder);
        }

        @Override
        public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IAnnuityHolder)((Object)this.annuityPersistence.createObject((IPersisteble)((Object)annHolder)));
        }

        @Override
        public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IContact)((Object)this.annuityPersistence.createObject((IPersisteble)((Object)contact)));
        }

        @Override
        public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IPayor)((Object)this.annuityPersistence.createObject((IPersisteble)((Object)payor)));
        }

        @Override
        public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(annHolder.getClass(), annHolder.getId(), annHolder);
        }

        @Override
        public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(contact.getClass(), contact.getId(), contact);
        }

        @Override
        public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(payor.getClass(), payor.getId(), payor);
        }

        @Override
        public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
            return (IAnnuityHolder)((Object)this.annuityPersistence.updateObject((IPersisteble)((Object)annHolder)));
        }

        @Override
        public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
            return (IContact)((Object)this.annuityPersistence.updateObject((IPersisteble)((Object)contact)));
        }

        @Override
        public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
            return (IPayor)((Object)this.annuityPersistence.updateObject((IPersisteble)((Object)payor)));
        }

        @Override
        public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(payout.getClass(), payout.getId(), payout);
        }

        @Override
        public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
            this.annuityPersistence.deleteObject(rider.getClass(), rider.getId(), rider);
        }

        @Override
        public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IPayor)this.annuityPersistence.readObject(payor.getClass(), payor.getId(), payor);
        }

        @Override
        public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IPayout)this.annuityPersistence.readObject(payout.getClass(), payout.getId(), payout);
        }

        @Override
        public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IRider)this.annuityPersistence.readObject(rider.getClass(), rider.getId(), rider);
        }

        @Override
        public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
            return this.annuityPersistence.getPayorAnnuities(payor);
        }

        @Override
        public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IPayout)((Object)this.annuityPersistence.createObject((IPersisteble)((Object)payout)));
        }

        @Override
        public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
            return (IPayout)((Object)this.annuityPersistence.updateObject((IPersisteble)((Object)payout)));
        }
    }
}

