/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDContactEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8980124038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Contact");
        IContact contact = null;
        try {
            contact = this.createContact();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Contact");
        try {
            this.verifyCreate(contact);
        }
        catch (Exception e) {
            this.logger.info("Create Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Contact");
        IContact updated = null;
        try {
            updated = this.updateContact(contact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Contact");
        try {
            this.verifyUpdate(updated);
        }
        catch (Exception e) {
            this.logger.info("Update Contact verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Contact");
        try {
            this.deleteContact(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Contact");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IContact createContact() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        contact.setConfiguration(this.getConfiguration());
        contact.setContactType(this.getRandomEnum(ContactType.class));
        contact = this.getServerAdapter().createContact(contact);
        return contact;
    }

    private IContact updateContact(IContact before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IContact after = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findContactById(after);
        after.setPhone(after.getPhone() + "-updated");
        after.setEmail(after.getEmail() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateContact(after);
        return after;
    }

    private void deleteContact(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact removed = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        removed.setId(contact.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteContact(removed);
    }

    private void verifyCreate(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "Contact from client is not equal to DB value", "Contact Create mismacth was found.");
    }

    private void verifyUpdate(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "Contact from client is not equal to DB value", "Contact Update mismacth was found.");
    }

    private void verifyDelete(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyContactDelete(contact, this, this.logger);
    }
}

