/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class DeleteAnnuityByProvidedIdRangeEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    private static final String START_ID = "startId";
    private static final String END_ID = "endId";

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            int startId = this.getParameterValueInt(START_ID);
            int endId = this.getParameterValueInt(END_ID);
            logger.info("startId=" + startId + ":endId=" + endId);
            for (int i = startId; i < endId; ++i) {
                IAnnuity result;
                IAnnuity annuity;
                try {
                    logger.fine("Attempting to delete ID:" + i);
                    annuity = this.getAnnuityBeansFactory().createAnnuity();
                    annuity.setId("" + i);
                    annuity.setConfiguration(this.getConfiguration());
                    result = this.getServerAdapter().findAnnuityById(annuity);
                }
                catch (EntityNotFoundException ex) {
                    throw new ExecutionUnitVerificationException("Delete Annuity Scenario failed.  The annity with id" + i + " does not exist!");
                }
                this.verifyFindSuccess(result, "" + i);
                this.getServerAdapter().deleteAnnuityById(annuity);
                try {
                    result = this.getServerAdapter().findAnnuityById(annuity);
                    if (result == null) continue;
                    throw new ExecutionUnitVerificationException("DeleteAnnuityByIdScenario indicated that the annuity was deleted.  However susequent calls were able to find it - If other threads created it, that would be OK - otherwise, this test has failed.  Annuity id: " + i);
                }
                catch (Exception ignore_me) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifyFindSuccess(IAnnuity annuity, String id) throws ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU failed to find an annuity.  retrned null value.");
        }
        if (!((String)annuity.getId()).equals(id)) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU returned a different object with with different id!expected id: " + id + " but was: " + (String)annuity.getId());
        }
    }
}

